/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.EventTimeline;
import org.jitsi.rtp.Packet;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0017\u0018\u0000 42\u00020\u0001:\u00014B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\bJ\u0006\u0010-\u001a\u00020\u0000J\u0014\u0010.\u001a\u00020\u00162\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0015\u00100\u001a\u0002H1\"\b\b\u0000\u00101*\u00020\u0003\u00a2\u0006\u0002\u0010\u0019J\u0006\u00102\u001a\u00020\u0016J\u0006\u00103\u001a\u00020\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R.\u0010\u0013\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u00010\u0014j\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u0001`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\fR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0010\"\u0004\b(\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00065"}, d2={"Lorg/jitsi/nlj/PacketInfo;", "", "packet", "Lorg/jitsi/rtp/Packet;", "timeline", "Lorg/jitsi/nlj/EventTimeline;", "(Lorg/jitsi/rtp/Packet;Lorg/jitsi/nlj/EventTimeline;)V", "endpointId", "", "getEndpointId", "()Ljava/lang/String;", "setEndpointId", "(Ljava/lang/String;)V", "layeringChanged", "", "getLayeringChanged", "()Z", "setLayeringChanged", "(Z)V", "onSentActions", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "getPacket", "()Lorg/jitsi/rtp/Packet;", "setPacket", "(Lorg/jitsi/rtp/Packet;)V", "payloadVerification", "getPayloadVerification", "setPayloadVerification", "value", "Ljava/time/Instant;", "receivedTime", "getReceivedTime", "()Ljava/time/Instant;", "setReceivedTime", "(Ljava/time/Instant;)V", "shouldDiscard", "getShouldDiscard", "setShouldDiscard", "getTimeline", "()Lorg/jitsi/nlj/EventTimeline;", "addEvent", "desc", "clone", "onSent", "action", "packetAs", "ExpectedPacketType", "resetPayloadVerification", "sent", "Companion", "jitsi-media-transform"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
public class PacketInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Packet packet;
    @NotNull
    private final EventTimeline timeline;
    @Nullable
    private Instant receivedTime;
    private boolean shouldDiscard;
    @Nullable
    private String endpointId;
    private boolean layeringChanged;
    @Nullable
    private String payloadVerification;
    @Nullable
    private ArrayList<Function0<Unit>> onSentActions;
    private static final boolean ENABLE_TIMELINE = false;
    private static boolean ENABLE_PAYLOAD_VERIFICATION;

    @JvmOverloads
    public PacketInfo(@NotNull Packet packet, @NotNull EventTimeline timeline) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(timeline, "timeline");
        this.packet = packet;
        this.timeline = timeline;
        this.payloadVerification = ENABLE_PAYLOAD_VERIFICATION ? this.packet.getPayloadVerification() : null;
    }

    public /* synthetic */ PacketInfo(Packet packet, EventTimeline eventTimeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            eventTimeline = new EventTimeline(null, null, 3, null);
        }
        this(packet, eventTimeline);
    }

    @NotNull
    public final Packet getPacket() {
        return this.packet;
    }

    public final void setPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "<set-?>");
        this.packet = packet;
    }

    @NotNull
    public final EventTimeline getTimeline() {
        return this.timeline;
    }

    @Nullable
    public final Instant getReceivedTime() {
        return this.receivedTime;
    }

    public final void setReceivedTime(@Nullable Instant value2) {
        this.receivedTime = value2;
    }

    public final boolean getShouldDiscard() {
        return this.shouldDiscard;
    }

    public final void setShouldDiscard(boolean bl) {
        this.shouldDiscard = bl;
    }

    @Nullable
    public final String getEndpointId() {
        return this.endpointId;
    }

    public final void setEndpointId(@Nullable String string) {
        this.endpointId = string;
    }

    public final boolean getLayeringChanged() {
        return this.layeringChanged;
    }

    public final void setLayeringChanged(boolean bl) {
        this.layeringChanged = bl;
    }

    @Nullable
    public final String getPayloadVerification() {
        return this.payloadVerification;
    }

    public final void setPayloadVerification(@Nullable String string) {
        this.payloadVerification = string;
    }

    public final void resetPayloadVerification() {
        this.payloadVerification = ENABLE_PAYLOAD_VERIFICATION ? this.packet.getPayloadVerification() : null;
    }

    @NotNull
    public final <ExpectedPacketType extends Packet> ExpectedPacketType packetAs() {
        return (ExpectedPacketType)this.packet;
    }

    @NotNull
    public final PacketInfo clone() {
        PacketInfo clone = new PacketInfo(this.packet.clone(), this.timeline);
        clone.setReceivedTime(this.receivedTime);
        clone.shouldDiscard = this.shouldDiscard;
        clone.endpointId = this.endpointId;
        clone.layeringChanged = this.layeringChanged;
        clone.payloadVerification = this.payloadVerification;
        ArrayList<Function0<Unit>> arrayList = this.onSentActions;
        clone.onSentActions = (ArrayList)(arrayList != null ? arrayList.clone() : null);
        return clone;
    }

    public final void addEvent(@NotNull String desc) {
        Intrinsics.checkNotNullParameter(desc, "desc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSent(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        PacketInfo packetInfo = this;
        synchronized (packetInfo) {
            boolean bl = false;
            if (this.onSentActions == null) {
                this.onSentActions = new ArrayList(1);
            }
            ArrayList<Function0<Unit>> arrayList = this.onSentActions;
            Intrinsics.checkNotNull(arrayList);
            boolean bl2 = arrayList.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sent() {
        List<Function0> actions = null;
        List<Function0> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, "emptyList()");
        actions = list;
        PacketInfo packetInfo = this;
        synchronized (packetInfo) {
            Unit unit;
            boolean bl = false;
            ArrayList<Function0<Unit>> arrayList = this.onSentActions;
            if (arrayList != null) {
                ArrayList<Function0<Unit>> it = arrayList;
                boolean bl2 = false;
                actions = it;
                this.onSentActions = null;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                PacketInfo $this$sent_u24lambda_u2d3_u24lambda_u2d2 = this;
                boolean bl3 = false;
                return;
            }
            Unit $i$a$-synchronized-PacketInfo$sent$2 = Unit.INSTANCE;
        }
        for (Function0 action : actions) {
            action.invoke();
        }
    }

    @JvmOverloads
    public PacketInfo(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this(packet, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/PacketInfo$Companion;", "", "()V", "ENABLE_PAYLOAD_VERIFICATION", "", "getENABLE_PAYLOAD_VERIFICATION", "()Z", "setENABLE_PAYLOAD_VERIFICATION", "(Z)V", "ENABLE_TIMELINE", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getENABLE_PAYLOAD_VERIFICATION() {
            return ENABLE_PAYLOAD_VERIFICATION;
        }

        public final void setENABLE_PAYLOAD_VERIFICATION(boolean bl) {
            ENABLE_PAYLOAD_VERIFICATION = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

