/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.TransportCcEngine$tccReceived$;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.Rfc3711IndexTracker;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.PacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.ReceivedPacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.UnreceivedPacketReport;
import org.jitsi.utils.RangedStringKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.json.simple.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u0005789:;B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010J\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\nJ\u000e\u0010/\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010J\u001a\u00100\u001a\u00020%2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u001d\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u001f\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00060#R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jitsi/nlj/rtp/TransportCcEngine;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "bandwidthEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "lastRtt", "Ljava/time/Duration;", "localReferenceTime", "Ljava/time/Instant;", "logger", "lossListeners", "", "Lorg/jitsi/nlj/rtp/LossListener;", "missingPacketDetailSeqNums", "", "numDuplicateReports", "Ljava/util/concurrent/atomic/LongAdder;", "getNumDuplicateReports", "()Ljava/util/concurrent/atomic/LongAdder;", "numMissingPacketReports", "getNumMissingPacketReports", "numPacketsReported", "getNumPacketsReported", "numPacketsReportedAfterLost", "getNumPacketsReportedAfterLost", "numPacketsReportedLost", "getNumPacketsReportedLost", "numPacketsUnreported", "getNumPacketsUnreported", "remoteReferenceTime", "sentPacketDetails", "Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetailTracker;", "addLossListener", "", "listener", "getStatistics", "Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "mediaPacketSent", "tccSeqNum", "length", "Lorg/jitsi/nlj/util/DataSize;", "onRttUpdate", "rtt", "removeLossListener", "rtcpPacketReceived", "rtcpPacket", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "tccReceived", "tccPacket", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "Companion", "PacketDetail", "PacketDetailState", "PacketDetailTracker", "StatisticsSnapshot", "jitsi-media-transform"})
public final class TransportCcEngine
implements RtcpListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BandwidthEstimator bandwidthEstimator;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LongAdder numPacketsReported;
    @NotNull
    private final LongAdder numPacketsReportedLost;
    @NotNull
    private final LongAdder numDuplicateReports;
    @NotNull
    private final LongAdder numPacketsReportedAfterLost;
    @NotNull
    private final LongAdder numPacketsUnreported;
    @NotNull
    private final LongAdder numMissingPacketReports;
    @NotNull
    private Instant remoteReferenceTime;
    @NotNull
    private Instant localReferenceTime;
    @NotNull
    private final PacketDetailTracker sentPacketDetails;
    @NotNull
    private final List<Integer> missingPacketDetailSeqNums;
    @Nullable
    private Duration lastRtt;
    @NotNull
    private final List<LossListener> lossListeners;
    private static final int MAX_OUTGOING_PACKETS_HISTORY = 1000;

    public TransportCcEngine(@NotNull BandwidthEstimator bandwidthEstimator, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(bandwidthEstimator, "bandwidthEstimator");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.bandwidthEstimator = bandwidthEstimator;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.numPacketsReported = new LongAdder();
        this.numPacketsReportedLost = new LongAdder();
        this.numDuplicateReports = new LongAdder();
        this.numPacketsReportedAfterLost = new LongAdder();
        this.numPacketsUnreported = new LongAdder();
        this.numMissingPacketReports = new LongAdder();
        this.remoteReferenceTime = ClockUtils.NEVER;
        this.localReferenceTime = ClockUtils.NEVER;
        this.sentPacketDetails = new PacketDetailTracker(this.clock);
        this.missingPacketDetailSeqNums = new ArrayList();
        this.lossListeners = new ArrayList();
    }

    public /* synthetic */ TransportCcEngine(BandwidthEstimator bandwidthEstimator, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(bandwidthEstimator, logger, clock);
    }

    @NotNull
    public final LongAdder getNumPacketsReported() {
        return this.numPacketsReported;
    }

    @NotNull
    public final LongAdder getNumPacketsReportedLost() {
        return this.numPacketsReportedLost;
    }

    @NotNull
    public final LongAdder getNumDuplicateReports() {
        return this.numDuplicateReports;
    }

    @NotNull
    public final LongAdder getNumPacketsReportedAfterLost() {
        return this.numPacketsReportedAfterLost;
    }

    @NotNull
    public final LongAdder getNumPacketsUnreported() {
        return this.numPacketsUnreported;
    }

    @NotNull
    public final LongAdder getNumMissingPacketReports() {
        return this.numMissingPacketReports;
    }

    public final void onRttUpdate(@NotNull Duration rtt) {
        Intrinsics.checkNotNullParameter(rtt, "rtt");
        Instant now = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(now, "now");
        this.bandwidthEstimator.onRttUpdate(now, rtt);
        this.lastRtt = rtt;
    }

    @Override
    public void rtcpPacketReceived(@NotNull RtcpPacket rtcpPacket, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter(rtcpPacket, "rtcpPacket");
        if (rtcpPacket instanceof RtcpFbTccPacket) {
            this.tccReceived((RtcpFbTccPacket)rtcpPacket);
        }
    }

    public final synchronized void addLossListener(@NotNull LossListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.lossListeners.add(listener);
    }

    public final synchronized void removeLossListener(@NotNull LossListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.lossListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void tccReceived(RtcpFbTccPacket tccPacket) {
        block21: {
            Object object;
            Object object2;
            String string;
            String string2;
            Logger logger;
            block23: {
                Object object3;
                TransportCcEngine it;
                Logger logger2;
                String string3;
                String string4;
                Object object4;
                block22: {
                    void $this$filterIsInstance$iv;
                    Object packetDetail;
                    Instant now = this.clock.instant();
                    Instant currArrivalTimestamp = ClockUtils.instantOfEpochMicro(tccPacket.GetBaseTimeUs());
                    if (Intrinsics.areEqual(this.remoteReferenceTime, ClockUtils.NEVER)) {
                        this.remoteReferenceTime = currArrivalTimestamp;
                        Intrinsics.checkNotNullExpressionValue(now, "now");
                        this.localReferenceTime = now;
                    }
                    for (PacketReport packetReport : tccPacket) {
                        int tccSeqNum = packetReport.getSeqNum();
                        packetDetail = this.sentPacketDetails.get(tccSeqNum);
                        if (packetDetail == null) {
                            if (!(packetReport instanceof ReceivedPacketReport)) continue;
                            Intrinsics.checkNotNullExpressionValue(currArrivalTimestamp.plus(((ReceivedPacketReport)packetReport).getDeltaDuration()), "currArrivalTimestamp += packetReport.deltaDuration");
                            this.missingPacketDetailSeqNums.add(tccSeqNum);
                            this.numMissingPacketReports.increment();
                            continue;
                        }
                        PacketReport packetReport2 = packetReport;
                        if (packetReport2 instanceof UnreceivedPacketReport) {
                            if (((PacketDetail)packetDetail).getState() != PacketDetailState.unreported) continue;
                            Intrinsics.checkNotNullExpressionValue(now, "now");
                            this.bandwidthEstimator.processPacketLoss(now, ((PacketDetail)packetDetail).getPacketSendTime$jitsi_media_transform(), tccSeqNum);
                            ((PacketDetail)packetDetail).setState(PacketDetailState.reportedLost);
                            this.numPacketsReported.increment();
                            this.numPacketsReportedLost.increment();
                            TransportCcEngine transportCcEngine = this;
                            synchronized (transportCcEngine) {
                                boolean bl = false;
                                Iterable $this$forEach$iv = this.lossListeners;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    LossListener it2 = (LossListener)element$iv;
                                    boolean bl2 = false;
                                    it2.packetLost(1);
                                }
                                Unit unit = Unit.INSTANCE;
                                continue;
                            }
                        }
                        if (!(packetReport2 instanceof ReceivedPacketReport)) continue;
                        Intrinsics.checkNotNullExpressionValue(currArrivalTimestamp.plus(((ReceivedPacketReport)packetReport).getDeltaDuration()), "currArrivalTimestamp += packetReport.deltaDuration");
                        switch (WhenMappings.$EnumSwitchMapping$0[((PacketDetail)packetDetail).getState().ordinal()]) {
                            case 1: 
                            case 2: {
                                boolean previouslyReportedLost;
                                boolean bl = previouslyReportedLost = ((PacketDetail)packetDetail).getState() == PacketDetailState.reportedLost;
                                if (previouslyReportedLost) {
                                    this.numPacketsReportedAfterLost.increment();
                                    this.numPacketsReportedLost.decrement();
                                } else {
                                    this.numPacketsReported.increment();
                                }
                                Instant arrivalTimeInLocalClock = currArrivalTimestamp.minus(Duration.between(this.localReferenceTime, this.remoteReferenceTime));
                                Intrinsics.checkNotNullExpressionValue(now, "now");
                                BandwidthEstimator.processPacketArrival$default(this.bandwidthEstimator, now, ((PacketDetail)packetDetail).getPacketSendTime$jitsi_media_transform(), arrivalTimeInLocalClock, tccSeqNum, ((PacketDetail)packetDetail).getPacketLength$jitsi_media_transform(), (byte)0, previouslyReportedLost, 32, null);
                                TransportCcEngine transportCcEngine = this;
                                synchronized (transportCcEngine) {
                                    boolean bl3 = false;
                                    Iterable $this$forEach$iv = this.lossListeners;
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        LossListener it3 = (LossListener)element$iv;
                                        boolean bl4 = false;
                                        it3.packetReceived(previouslyReportedLost);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                ((PacketDetail)packetDetail).setState(PacketDetailState.reportedReceived);
                                break;
                            }
                            case 3: {
                                this.numDuplicateReports.increment();
                            }
                        }
                    }
                    Intrinsics.checkNotNullExpressionValue(now, "now");
                    this.bandwidthEstimator.feedbackComplete(now);
                    if (!(!((Collection)this.missingPacketDetailSeqNums).isEmpty())) break block21;
                    logger = this.logger;
                    Sequence<PacketReport> sequence = SequencesKt.asSequence(tccPacket.iterator());
                    boolean $i$f$filterIsInstance = false;
                    string2 = RangedStringKt.joinToRangedString$default(SequencesKt.map(SequencesKt.filter($this$filterIsInstance$iv, tccReceived$$inlined$filterIsInstance$1.INSTANCE), tccReceived.3.INSTANCE), null, null, null, null, 0, null, 63, null);
                    string = RangedStringKt.joinToRangedString$default(this.missingPacketDetailSeqNums, null, null, null, null, 0, null, 63, null);
                    object2 = this.sentPacketDetails.getEmpty() ? "Sent packet details map was empty." : "Latest seqNum was " + this.sentPacketDetails.getLastSequence() + ", size is " + this.sentPacketDetails.getSize() + ".";
                    object = this.lastRtt;
                    if (object == null) break block22;
                    packetDetail = object;
                    object4 = object2;
                    string4 = string;
                    string3 = string2;
                    logger2 = logger;
                    boolean bl = false;
                    object3 = " Latest RTT is " + ClockUtils.formatMilli((Duration)((Object)it)) + " ms.";
                    logger = logger2;
                    string2 = string3;
                    string = string4;
                    object2 = object4;
                    Object object5 = object3;
                    object = object5;
                    if (object5 != null) break block23;
                }
                it = this;
                object4 = object2;
                string4 = string;
                string3 = string2;
                logger2 = logger;
                boolean bl = false;
                object3 = "";
                logger = logger2;
                string2 = string3;
                string = string4;
                object2 = object4;
                object = object3;
            }
            logger.warn("TCC packet contained received sequence numbers: " + string2 + ". Couldn't find packet detail for the seq nums: " + string + ". " + (String)object2 + (String)object);
            this.missingPacketDetailSeqNums.clear();
        }
    }

    public final void mediaPacketSent(int tccSeqNum, @NotNull DataSize length) {
        Intrinsics.checkNotNullParameter(length, "length");
        Instant now = this.clock.instant();
        int seq = tccSeqNum & 0xFFFF;
        Intrinsics.checkNotNullExpressionValue(now, "now");
        if (!this.sentPacketDetails.insert(seq, new PacketDetail(length, now))) {
            this.logger.warn("Not inserting very old TCC seq num " + seq + " (" + tccSeqNum + "), latest is " + this.sentPacketDetails.getLastSequence() + ", size is " + this.sentPacketDetails.getSize());
            return;
        }
    }

    @NotNull
    public final StatisticsSnapshot getStatistics() {
        return new StatisticsSnapshot(this.numPacketsReported.sum(), this.numPacketsReportedLost.sum(), this.numDuplicateReports.sum(), this.numPacketsReportedAfterLost.sum(), this.numPacketsUnreported.sum(), this.numMissingPacketReports.sum());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetailState;", "", "(Ljava/lang/String;I)V", "unreported", "reportedLost", "reportedReceived", "jitsi-media-transform"})
    private static final class PacketDetailState
    extends Enum<PacketDetailState> {
        public static final /* enum */ PacketDetailState unreported = new PacketDetailState();
        public static final /* enum */ PacketDetailState reportedLost = new PacketDetailState();
        public static final /* enum */ PacketDetailState reportedReceived = new PacketDetailState();
        private static final /* synthetic */ PacketDetailState[] $VALUES;

        public static PacketDetailState[] values() {
            return (PacketDetailState[])$VALUES.clone();
        }

        public static PacketDetailState valueOf(String value2) {
            return Enum.valueOf(PacketDetailState.class, value2);
        }

        static {
            $VALUES = packetDetailStateArray = new PacketDetailState[]{PacketDetailState.unreported, PacketDetailState.reportedLost, PacketDetailState.reportedReceived};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetail;", "", "packetLength", "Lorg/jitsi/nlj/util/DataSize;", "packetSendTime", "Ljava/time/Instant;", "(Lorg/jitsi/nlj/util/DataSize;Ljava/time/Instant;)V", "getPacketLength$jitsi_media_transform", "()Lorg/jitsi/nlj/util/DataSize;", "getPacketSendTime$jitsi_media_transform", "()Ljava/time/Instant;", "state", "Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetailState;", "getState", "()Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetailState;", "setState", "(Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetailState;)V", "component1", "component1$jitsi_media_transform", "component2", "component2$jitsi_media_transform", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    private static final class PacketDetail {
        @NotNull
        private final DataSize packetLength;
        @NotNull
        private final Instant packetSendTime;
        @NotNull
        private PacketDetailState state;

        public PacketDetail(@NotNull DataSize packetLength, @NotNull Instant packetSendTime) {
            Intrinsics.checkNotNullParameter(packetLength, "packetLength");
            Intrinsics.checkNotNullParameter(packetSendTime, "packetSendTime");
            this.packetLength = packetLength;
            this.packetSendTime = packetSendTime;
            this.state = PacketDetailState.unreported;
        }

        @NotNull
        public final DataSize getPacketLength$jitsi_media_transform() {
            return this.packetLength;
        }

        @NotNull
        public final Instant getPacketSendTime$jitsi_media_transform() {
            return this.packetSendTime;
        }

        @NotNull
        public final PacketDetailState getState() {
            return this.state;
        }

        public final void setState(@NotNull PacketDetailState packetDetailState) {
            Intrinsics.checkNotNullParameter((Object)packetDetailState, "<set-?>");
            this.state = packetDetailState;
        }

        @NotNull
        public final DataSize component1$jitsi_media_transform() {
            return this.packetLength;
        }

        @NotNull
        public final Instant component2$jitsi_media_transform() {
            return this.packetSendTime;
        }

        @NotNull
        public final PacketDetail copy(@NotNull DataSize packetLength, @NotNull Instant packetSendTime) {
            Intrinsics.checkNotNullParameter(packetLength, "packetLength");
            Intrinsics.checkNotNullParameter(packetSendTime, "packetSendTime");
            return new PacketDetail(packetLength, packetSendTime);
        }

        public static /* synthetic */ PacketDetail copy$default(PacketDetail packetDetail, DataSize dataSize, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                dataSize = packetDetail.packetLength;
            }
            if ((n & 2) != 0) {
                instant = packetDetail.packetSendTime;
            }
            return packetDetail.copy(dataSize, instant);
        }

        @NotNull
        public String toString() {
            return "PacketDetail(packetLength=" + this.packetLength + ", packetSendTime=" + this.packetSendTime + ")";
        }

        public int hashCode() {
            int result2 = this.packetLength.hashCode();
            result2 = result2 * 31 + this.packetSendTime.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PacketDetail)) {
                return false;
            }
            PacketDetail packetDetail = (PacketDetail)other;
            if (!Intrinsics.areEqual(this.packetLength, packetDetail.packetLength)) {
                return false;
            }
            return Intrinsics.areEqual(this.packetSendTime, packetDetail.packetSendTime);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "", "numPacketsReported", "", "numPacketsReportedLost", "numDuplicateReports", "numPacketsReportedAfterLost", "numPacketsUnreported", "numMissingPacketReports", "(JJJJJJ)V", "getNumDuplicateReports", "()J", "getNumMissingPacketReports", "getNumPacketsReported", "getNumPacketsReportedAfterLost", "getNumPacketsReportedLost", "getNumPacketsUnreported", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toJson", "Lorg/json/simple/JSONObject;", "toString", "", "jitsi-media-transform"})
    public static final class StatisticsSnapshot {
        private final long numPacketsReported;
        private final long numPacketsReportedLost;
        private final long numDuplicateReports;
        private final long numPacketsReportedAfterLost;
        private final long numPacketsUnreported;
        private final long numMissingPacketReports;

        public StatisticsSnapshot(long numPacketsReported, long numPacketsReportedLost, long numDuplicateReports, long numPacketsReportedAfterLost, long numPacketsUnreported, long numMissingPacketReports) {
            this.numPacketsReported = numPacketsReported;
            this.numPacketsReportedLost = numPacketsReportedLost;
            this.numDuplicateReports = numDuplicateReports;
            this.numPacketsReportedAfterLost = numPacketsReportedAfterLost;
            this.numPacketsUnreported = numPacketsUnreported;
            this.numMissingPacketReports = numMissingPacketReports;
        }

        public final long getNumPacketsReported() {
            return this.numPacketsReported;
        }

        public final long getNumPacketsReportedLost() {
            return this.numPacketsReportedLost;
        }

        public final long getNumDuplicateReports() {
            return this.numDuplicateReports;
        }

        public final long getNumPacketsReportedAfterLost() {
            return this.numPacketsReportedAfterLost;
        }

        public final long getNumPacketsUnreported() {
            return this.numPacketsUnreported;
        }

        public final long getNumMissingPacketReports() {
            return this.numMissingPacketReports;
        }

        @NotNull
        public final JSONObject toJson() {
            JSONObject jSONObject;
            JSONObject it = jSONObject = new JSONObject();
            boolean bl = false;
            it.put("numPacketsReported", this.numPacketsReported);
            it.put("numPacketsReportedLost", this.numPacketsReportedLost);
            it.put("numDuplicateReports", this.numDuplicateReports);
            it.put("numPacketsReportedAfterLost", this.numPacketsReportedAfterLost);
            it.put("numPacketsUnreported", this.numPacketsUnreported);
            it.put("numMissingPacketReports", this.numMissingPacketReports);
            return jSONObject;
        }

        public final long component1() {
            return this.numPacketsReported;
        }

        public final long component2() {
            return this.numPacketsReportedLost;
        }

        public final long component3() {
            return this.numDuplicateReports;
        }

        public final long component4() {
            return this.numPacketsReportedAfterLost;
        }

        public final long component5() {
            return this.numPacketsUnreported;
        }

        public final long component6() {
            return this.numMissingPacketReports;
        }

        @NotNull
        public final StatisticsSnapshot copy(long numPacketsReported, long numPacketsReportedLost, long numDuplicateReports, long numPacketsReportedAfterLost, long numPacketsUnreported, long numMissingPacketReports) {
            return new StatisticsSnapshot(numPacketsReported, numPacketsReportedLost, numDuplicateReports, numPacketsReportedAfterLost, numPacketsUnreported, numMissingPacketReports);
        }

        public static /* synthetic */ StatisticsSnapshot copy$default(StatisticsSnapshot statisticsSnapshot, long l, long l2, long l3, long l4, long l5, long l6, int n, Object object) {
            if ((n & 1) != 0) {
                l = statisticsSnapshot.numPacketsReported;
            }
            if ((n & 2) != 0) {
                l2 = statisticsSnapshot.numPacketsReportedLost;
            }
            if ((n & 4) != 0) {
                l3 = statisticsSnapshot.numDuplicateReports;
            }
            if ((n & 8) != 0) {
                l4 = statisticsSnapshot.numPacketsReportedAfterLost;
            }
            if ((n & 0x10) != 0) {
                l5 = statisticsSnapshot.numPacketsUnreported;
            }
            if ((n & 0x20) != 0) {
                l6 = statisticsSnapshot.numMissingPacketReports;
            }
            return statisticsSnapshot.copy(l, l2, l3, l4, l5, l6);
        }

        @NotNull
        public String toString() {
            return "StatisticsSnapshot(numPacketsReported=" + this.numPacketsReported + ", numPacketsReportedLost=" + this.numPacketsReportedLost + ", numDuplicateReports=" + this.numDuplicateReports + ", numPacketsReportedAfterLost=" + this.numPacketsReportedAfterLost + ", numPacketsUnreported=" + this.numPacketsUnreported + ", numMissingPacketReports=" + this.numMissingPacketReports + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.numPacketsReported);
            result2 = result2 * 31 + Long.hashCode(this.numPacketsReportedLost);
            result2 = result2 * 31 + Long.hashCode(this.numDuplicateReports);
            result2 = result2 * 31 + Long.hashCode(this.numPacketsReportedAfterLost);
            result2 = result2 * 31 + Long.hashCode(this.numPacketsUnreported);
            result2 = result2 * 31 + Long.hashCode(this.numMissingPacketReports);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatisticsSnapshot)) {
                return false;
            }
            StatisticsSnapshot statisticsSnapshot = (StatisticsSnapshot)other;
            if (this.numPacketsReported != statisticsSnapshot.numPacketsReported) {
                return false;
            }
            if (this.numPacketsReportedLost != statisticsSnapshot.numPacketsReportedLost) {
                return false;
            }
            if (this.numDuplicateReports != statisticsSnapshot.numDuplicateReports) {
                return false;
            }
            if (this.numPacketsReportedAfterLost != statisticsSnapshot.numPacketsReportedAfterLost) {
                return false;
            }
            if (this.numPacketsUnreported != statisticsSnapshot.numPacketsUnreported) {
                return false;
            }
            return this.numMissingPacketReports == statisticsSnapshot.numMissingPacketReports;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0002R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetailTracker;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/nlj/rtp/TransportCcEngine$PacketDetail;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/nlj/rtp/TransportCcEngine;Ljava/time/Clock;)V", "lastSequence", "", "getLastSequence", "()I", "rfc3711IndexTracker", "Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "discardItem", "", "item", "get", "sequenceNumber", "insert", "", "seq", "packetDetail", "jitsi-media-transform"})
    private final class PacketDetailTracker
    extends ArrayCache<PacketDetail> {
        @NotNull
        private final Rfc3711IndexTracker rfc3711IndexTracker;

        public PacketDetailTracker(Clock clock) {
            Intrinsics.checkNotNullParameter(clock, "clock");
            super(1000, 1.INSTANCE, false, clock, 4, null);
            this.rfc3711IndexTracker = new Rfc3711IndexTracker();
        }

        @Override
        protected void discardItem(@NotNull PacketDetail item) {
            Intrinsics.checkNotNullParameter(item, "item");
            if (item.getState() == PacketDetailState.unreported) {
                TransportCcEngine.this.getNumPacketsUnreported().increment();
            }
        }

        @Nullable
        public final PacketDetail get(int sequenceNumber) {
            int index = this.rfc3711IndexTracker.interpret(sequenceNumber);
            ArrayCache.Container container = super.getContainer(index, true);
            return container != null ? (PacketDetail)container.getItem() : null;
        }

        public final boolean insert(int seq, @NotNull PacketDetail packetDetail) {
            Intrinsics.checkNotNullParameter(packetDetail, "packetDetail");
            int index = this.rfc3711IndexTracker.update(seq);
            return super.insertItem(packetDetail, index, packetDetail.getPacketSendTime$jitsi_media_transform().toEpochMilli());
        }

        public final int getLastSequence() {
            return this.getLastIndex() == -1 ? -1 : this.getLastIndex() & 0xFFFF;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/nlj/rtp/TransportCcEngine$Companion;", "", "()V", "MAX_OUTGOING_PACKETS_HISTORY", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PacketDetailState.values().length];
            nArray[PacketDetailState.unreported.ordinal()] = 1;
            nArray[PacketDetailState.reportedLost.ordinal()] = 2;
            nArray[PacketDetailState.reportedReceived.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

