/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp8;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.codec.vp8.Vp8Utils;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi_modified.impl.neomedia.codec.video.vp8.DePacketizer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B[\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\b\u0010,\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020%H\u0016R$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u0014\u0010!\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0019R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0019R\u0014\u0010\"\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R$\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0012\u00a8\u0006/"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp8/Vp8Packet;", "Lorg/jitsi/nlj/rtp/ParsedVideoPacket;", "buffer", "", "offset", "", "length", "([BII)V", "isKeyframe", "", "isStartOfFrame", "encodingIndex", "height", "pictureId", "TL0PICIDX", "([BIILjava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "newValue", "getTL0PICIDX", "()I", "setTL0PICIDX", "(I)V", "_TL0PICIDX", "_pictureId", "hasExtendedPictureId", "getHasExtendedPictureId", "()Z", "hasPictureId", "getHasPictureId", "hasTL0PICIDX", "getHasTL0PICIDX", "hasTemporalLayerIndex", "getHasTemporalLayerIndex", "getHeight", "isEndOfFrame", "layerId", "getLayerId", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "getPictureId", "setPictureId", "temporalLayerIndex", "getTemporalLayerIndex", "clone", "toString", "Companion", "jitsi-media-transform"})
public final class Vp8Packet
extends ParsedVideoPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isKeyframe;
    private final boolean isStartOfFrame;
    private final boolean hasTemporalLayerIndex;
    private final boolean hasPictureId;
    private final boolean hasExtendedPictureId;
    private final boolean hasTL0PICIDX;
    private int _TL0PICIDX;
    private int _pictureId;
    private final int temporalLayerIndex;
    private final int height;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null);

    private Vp8Packet(byte[] buffer, int offset, int length, Boolean isKeyframe, Boolean isStartOfFrame, Integer encodingIndex, Integer height, Integer pictureId, Integer TL0PICIDX) {
        super(buffer, offset, length, encodingIndex);
        Boolean bl = isKeyframe;
        this.isKeyframe = bl != null ? bl : DePacketizer.isKeyFrame(this.buffer, this.getPayloadOffset(), this.getPayloadLength());
        Boolean bl2 = isStartOfFrame;
        this.isStartOfFrame = bl2 != null ? bl2 : DePacketizer.VP8PayloadDescriptor.isStartOfFrame(buffer, this.getPayloadOffset());
        this.hasTemporalLayerIndex = DePacketizer.VP8PayloadDescriptor.hasTemporalLayerIndex(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasPictureId = DePacketizer.VP8PayloadDescriptor.hasPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasExtendedPictureId = DePacketizer.VP8PayloadDescriptor.hasExtendedPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasTL0PICIDX = DePacketizer.VP8PayloadDescriptor.hasTL0PICIDX(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Integer n = TL0PICIDX;
        this._TL0PICIDX = n != null ? n : DePacketizer.VP8PayloadDescriptor.getTL0PICIDX(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Integer n2 = pictureId;
        this._pictureId = n2 != null ? n2 : DePacketizer.VP8PayloadDescriptor.getPictureId(buffer, this.getPayloadOffset());
        this.temporalLayerIndex = Vp8Utils.Companion.getTemporalLayerIdOfFrame(this);
        Integer n3 = height;
        this.height = n3 != null ? n3 : (this.isKeyframe() ? Vp8Utils.Companion.getHeightFromKeyFrame(this) : -1);
    }

    public Vp8Packet(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this(buffer, offset, length, null, null, null, null, null, null);
    }

    @Override
    public boolean isKeyframe() {
        return this.isKeyframe;
    }

    @Override
    public boolean isStartOfFrame() {
        return this.isStartOfFrame;
    }

    @Override
    public boolean isEndOfFrame() {
        return this.isMarked();
    }

    public final boolean getHasTemporalLayerIndex() {
        return this.hasTemporalLayerIndex;
    }

    public final boolean getHasPictureId() {
        return this.hasPictureId;
    }

    public final boolean getHasExtendedPictureId() {
        return this.hasExtendedPictureId;
    }

    public final boolean getHasTL0PICIDX() {
        return this.hasTL0PICIDX;
    }

    public final int getTL0PICIDX() {
        return this._TL0PICIDX;
    }

    public final void setTL0PICIDX(int newValue) {
        this._TL0PICIDX = newValue;
        if (newValue != -1 && !DePacketizer.VP8PayloadDescriptor.setTL0PICIDX(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), newValue)) {
            Logger $this$cwarn$iv = logger;
            boolean $i$f$cwarn = false;
            if ($this$cwarn$iv.isWarnEnabled()) {
                Logger logger = $this$cwarn$iv;
                boolean bl = false;
                logger.warn("Failed to set the TL0PICIDX of a VP8 packet.");
            }
        }
    }

    public final int getPictureId() {
        return this._pictureId;
    }

    public final void setPictureId(int newValue) {
        this._pictureId = newValue;
        if (!DePacketizer.VP8PayloadDescriptor.setExtendedPictureId(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), newValue)) {
            Logger $this$cwarn$iv = logger;
            boolean $i$f$cwarn = false;
            if ($this$cwarn$iv.isWarnEnabled()) {
                Logger logger = $this$cwarn$iv;
                boolean bl = false;
                logger.warn("Failed to set the picture id of a VP8 packet.");
            }
        }
    }

    public final int getTemporalLayerIndex() {
        return this.temporalLayerIndex;
    }

    @Override
    public int getLayerId() {
        return this.hasTemporalLayerIndex ? RtpLayerDesc.Companion.getIndex(0, 0, this.temporalLayerIndex) : super.getLayerId();
    }

    public final int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        int rtpPayloadLength = this.getPayloadLength();
        int rtpPayloadOffset = this.getPayloadOffset();
        int vp8pdSize = DePacketizer.VP8PayloadDescriptor.getSize(this.buffer, rtpPayloadOffset, rtpPayloadLength);
        int vp8PayloadLength = rtpPayloadLength - vp8pdSize;
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        int hashCode2 = ByteArrayExtensionsKt.hashCodeOfSegment(this.buffer, this.getPayloadOffset() + vp8pdSize, rtpPayloadOffset + rtpPayloadLength);
        return "type=Vp8Packet len=" + vp8PayloadLength + " hashCode=" + hashCode2;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + ", TID=" + this.temporalLayerIndex;
    }

    @Override
    @NotNull
    public Vp8Packet clone() {
        return new Vp8Packet(this.cloneBuffer(10), 10, this.length, this.isKeyframe(), this.isStartOfFrame(), this.getQualityIndex(), this.height, this.getPictureId(), this.getTL0PICIDX());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp8/Vp8Packet$Companion;", "", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

