/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsSnapshot;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.RtpUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0014J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "ssrcStats", "", "", "Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "getSnapshot", "Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsSnapshot;", "getSnapshotOfActiveSsrcs", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class IncomingStatisticsTracker
extends ObserverNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Map<Long, IncomingSsrcStats> ssrcStats;

    public IncomingStatisticsTracker(@NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        super("Incoming statistics tracker");
        this.streamInformationStore = streamInformationStore;
        this.ssrcStats = new ConcurrentHashMap();
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            PayloadType payloadType = this.streamInformationStore.getRtpPayloadTypes().get((byte)rtpPacket.getPayloadType());
            if (payloadType == null) break block2;
            PayloadType payloadType2 = payloadType;
            boolean bl = false;
            if (!(payloadType2 instanceof RtxPayloadType)) {
                IncomingSsrcStats incomingSsrcStats = this.ssrcStats.computeIfAbsent(rtpPacket.getSsrc(), arg_0 -> IncomingStatisticsTracker.observe$lambda-2$lambda-0(rtpPacket, payloadType2, arg_0));
                Intrinsics.checkNotNullExpressionValue(incomingSsrcStats, "ssrcStats.computeIfAbsen\u2026iaType)\n                }");
                IncomingSsrcStats stats = incomingSsrcStats;
                Instant packetSentTimestamp = RtpUtils.Companion.convertRtpTimestampToInstant((int)rtpPacket.getTimestamp(), payloadType2.getClockRate());
                Instant instant = packetInfo.getReceivedTime();
                if (instant != null) {
                    Instant it = instant;
                    boolean bl2 = false;
                    stats.packetReceived(rtpPacket, packetSentTimestamp, it);
                }
            }
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d4 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        IncomingStatisticsSnapshot stats = this.getSnapshot();
        Map<Long, IncomingSsrcStats.Snapshot> $this$forEach$iv = stats.getSsrcStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, IncomingSsrcStats.Snapshot>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, IncomingSsrcStats.Snapshot> element$iv;
            Map.Entry<Long, IncomingSsrcStats.Snapshot> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            IncomingSsrcStats.Snapshot streamStats = entry.getValue();
            $this$getNodeStats_u24lambda_u2d4.addJson(String.valueOf(ssrc2), streamStats.toJson());
        }
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        return super.getNodeStats();
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncomingStatisticsSnapshot getSnapshotOfActiveSsrcs() {
        void $this$mapNotNullTo$iv$iv;
        Map<Long, IncomingSsrcStats> $this$mapNotNull$iv = this.ssrcStats;
        boolean $i$f$mapNotNull = false;
        Map<Long, IncomingSsrcStats> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair<Long, IncomingSsrcStats.Snapshot> pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            IncomingSsrcStats stats = (IncomingSsrcStats)entry.getValue();
            if (stats.getSnapshotIfActive() != null) {
                IncomingSsrcStats.Snapshot it;
                boolean bl3 = false;
                pair = new Pair<Long, IncomingSsrcStats.Snapshot>(ssrc2, it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair<Long, IncomingSsrcStats.Snapshot> it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map<Long, IncomingSsrcStats.Snapshot> map2 = MapsKt.toMap((List)destination$iv$iv);
        return new IncomingStatisticsSnapshot(map2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncomingStatisticsSnapshot getSnapshot() {
        void $this$mapTo$iv$iv;
        Map<Long, IncomingSsrcStats> $this$map$iv = this.ssrcStats;
        boolean $i$f$map = false;
        Map<Long, IncomingSsrcStats> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            IncomingSsrcStats stats = (IncomingSsrcStats)entry.getValue();
            collection.add(new Pair<Long, IncomingSsrcStats.Snapshot>(ssrc2, stats.getSnapshot()));
        }
        Map<Long, IncomingSsrcStats.Snapshot> map2 = MapsKt.toMap((List)destination$iv$iv);
        return new IncomingStatisticsSnapshot(map2);
    }

    private static final IncomingSsrcStats observe$lambda-2$lambda-0(RtpPacket $rtpPacket, PayloadType $payloadType, Long it) {
        Intrinsics.checkNotNullParameter($rtpPacket, "$rtpPacket");
        Intrinsics.checkNotNullParameter($payloadType, "$payloadType");
        Intrinsics.checkNotNullParameter(it, "it");
        return new IncomingSsrcStats($rtpPacket.getSsrc(), $rtpPacket.getSequenceNumber(), $payloadType.getMediaType());
    }
}

