/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.datachannel.protocol;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jitsi.videobridge.datachannel.protocol.DataChannelProtocolMessage;

public class OpenChannelMessage
extends DataChannelProtocolMessage {
    public final int channelType;
    public final int priority;
    public final long reliability;
    public final String label;
    public final String protocol;

    public OpenChannelMessage(int channelType, int priority, long reliability, String label, String protocol) {
        super(3);
        this.channelType = channelType;
        this.priority = priority;
        this.reliability = reliability;
        this.label = label;
        this.protocol = protocol;
    }

    public static OpenChannelMessage parse(byte[] data2) {
        ByteBuffer buf = ByteBuffer.wrap(data2);
        byte channelType = buf.get(1);
        short priority = buf.getShort(2);
        long reliability = buf.getInt(4);
        short labelLength = buf.getShort(8);
        short protocolLength = buf.getShort(10);
        String label = null;
        if (labelLength > 0) {
            ((Buffer)buf).position(12);
            byte[] labelBytes = new byte[labelLength];
            buf.get(labelBytes, 0, labelLength);
            label = new String(labelBytes);
        }
        String protocol = null;
        if (protocolLength > 0) {
            ((Buffer)buf).position(12 + labelLength);
            byte[] protocolBytes = new byte[protocolLength];
            buf.get(protocolBytes, 0, protocolLength);
            protocol = new String(protocolBytes);
        }
        return new OpenChannelMessage(channelType, priority, reliability, label, protocol);
    }

    @Override
    protected int getSizeBytes() {
        byte[] labelBytes = this.label.getBytes(StandardCharsets.UTF_8);
        int labelLength = Math.min(labelBytes.length, 65535);
        byte[] protocolBytes = this.protocol.getBytes(StandardCharsets.UTF_8);
        int protocolLength = Math.min(protocolBytes.length, 65535);
        return super.getSizeBytes() + 11 + labelLength + protocolLength;
    }

    @Override
    public void serialize(ByteBuffer destination) {
        super.serialize(destination);
        destination.put((byte)this.channelType);
        destination.putShort((short)this.priority);
        destination.putInt((int)this.reliability);
        byte[] labelBytes = this.label.getBytes(StandardCharsets.UTF_8);
        int labelLength = Math.min(labelBytes.length, 65535);
        byte[] protocolBytes = this.protocol.getBytes(StandardCharsets.UTF_8);
        int protocolLength = Math.min(protocolBytes.length, 65535);
        destination.putShort((short)labelLength);
        destination.putShort((short)protocolLength);
        destination.put(labelBytes, 0, labelLength);
        destination.put(protocolBytes, 0, protocolLength);
    }
}

