/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.MediaSources;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpReceiverEventHandler;
import org.jitsi.nlj.RtpReceiverImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.RtpReceiverStats;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.nlj.util.StreamInformationStoreImpl;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.message.AddReceiverMessage;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.relay.RelayedPacketInfo;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001XB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020*H\u0016J\b\u00101\u001a\u000202H\u0016J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000206J(\u00107\u001a\"\u0012\f\u0012\n :*\u0004\u0018\u0001090908j\u0010\u0012\f\u0012\n :*\u0004\u0018\u00010909`;H\u0016J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020>H\u0016J\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020@H\u0016J\b\u0010B\u001a\u00020@H\u0016J\u0010\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u000209H\u0016J\u0006\u0010E\u001a\u00020*J\b\u0010F\u001a\u00020*H\u0016J\u0010\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u000209H\u0016J\u0010\u0010H\u001a\u00020*2\u0006\u0010I\u001a\u00020JH\u0014J\u0018\u0010K\u001a\u00020*2\u0006\u0010L\u001a\u00020\b2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010M\u001a\u00020*2\u0006\u0010N\u001a\u00020@H\u0016J\u0016\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020@J\u000e\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u00020UJ\b\u0010V\u001a\u00020@H\u0016J\b\u0010W\u001a\u00020*H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00190\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jitsi/videobridge/relay/RelayedEndpoint;", "Lorg/jitsi/videobridge/AbstractEndpoint;", "Lorg/jitsi/videobridge/relay/Relay$IncomingRelayPacketHandler;", "conference", "Lorg/jitsi/videobridge/Conference;", "relay", "Lorg/jitsi/videobridge/relay/Relay;", "id", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "(Lorg/jitsi/videobridge/Conference;Lorg/jitsi/videobridge/relay/Relay;Ljava/lang/String;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "_mediaSources", "Lorg/jitsi/nlj/MediaSources;", "value", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "audioSources", "getAudioSources", "()[Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "setAudioSources", "([Lorg/jitsi/videobridge/relay/AudioSourceDesc;)V", "[Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "Lorg/jitsi/nlj/MediaSourceDesc;", "mediaSources", "getMediaSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "setMediaSources", "([Lorg/jitsi/nlj/MediaSourceDesc;)V", "getRelay", "()Lorg/jitsi/videobridge/relay/Relay;", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "getRtcpEventNotifier", "()Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "rtpReceiver", "Lorg/jitsi/nlj/RtpReceiverImpl;", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStore;", "addPayloadType", "", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "expire", "getDebugState", "Lorg/json/simple/JSONObject;", "getIncomingStats", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getSsrcs", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "Lkotlin/collections/HashSet;", "handleIncomingPacket", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "hasReceiveSsrcs", "", "isSendingAudio", "isSendingVideo", "receivesSsrc", "ssrc", "relayMessageTransportConnected", "requestKeyframe", "mediaSsrc", "sendVideoConstraints", "maxVideoConstraints", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "sendVideoConstraintsV2", "sourceName", "setExtmapAllowMixed", "allow", "setFeature", "feature", "Lorg/jitsi/nlj/Features;", "enabled", "setSrtpInformation", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "shouldExpire", "updateStatsOnExpire", "RtpReceiverEventHandlerImpl", "jitsi-videobridge"})
public final class RelayedEndpoint
extends AbstractEndpoint
implements Relay.IncomingRelayPacketHandler {
    @NotNull
    private final Relay relay;
    @NotNull
    private AudioSourceDesc[] audioSources;
    @NotNull
    private final StreamInformationStore streamInformationStore;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final RtpReceiverImpl rtpReceiver;
    @NotNull
    private final MediaSources _mediaSources;

    /*
     * WARNING - void declaration
     */
    public RelayedEndpoint(@NotNull Conference conference, @NotNull Relay relay, @NotNull String id, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        void $this$rtpReceiver_u24lambda_u2d2;
        Object $this$rtcpEventNotifier_u24lambda_u2d1;
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(relay, "relay");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        super(conference, id, parentLogger);
        this.relay = relay;
        this.audioSources = new AudioSourceDesc[0];
        this.streamInformationStore = new StreamInformationStoreImpl();
        Object object = new RtcpEventNotifier();
        RtcpEventNotifier rtcpEventNotifier2 = object;
        RelayedEndpoint relayedEndpoint = this;
        boolean bl = false;
        ((RtcpEventNotifier)$this$rtcpEventNotifier_u24lambda_u2d1).addRtcpEventListener(new RtcpListener(this, id){
            final /* synthetic */ RelayedEndpoint this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
            }

            public void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.getRelay().rtcpPacketReceived(packet, receivedTime, this.$id);
            }

            public void rtcpPacketSent(@NotNull RtcpPacket packet) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                throw new IllegalStateException("got rtcpPacketSent callback from a receiver");
            }
        }, true);
        relayedEndpoint.rtcpEventNotifier = object;
        String string = this.relay.getId() + "-" + id;
        Function1 function1 = new Function1<RtcpPacket, Unit>(this){
            final /* synthetic */ RelayedEndpoint this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RtcpPacket rtcpPacket) {
                Intrinsics.checkNotNullParameter(rtcpPacket, "rtcpPacket");
                if (rtcpPacket.length >= 1500) {
                    RelayedEndpoint.access$getLogger$p$s-2050099067(this.this$0).warn("Sending large locally-generated RTCP packet of size " + rtcpPacket.length + ", first packet of type " + rtcpPacket.getPacketType() + " rc " + rtcpPacket.getReportCount() + ".");
                }
                this.this$0.getRelay().getTransceiver().sendPacket(new PacketInfo(rtcpPacket, null, 2, null));
            }
        };
        ExecutorService executorService = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        ReadOnlyStreamInformationStore readOnlyStreamInformationStore = this.streamInformationStore;
        RtpReceiverEventHandler rtpReceiverEventHandler = new RtpReceiverEventHandlerImpl();
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        $this$rtcpEventNotifier_u24lambda_u2d1 = object = new RtpReceiverImpl(string, function1, this.rtcpEventNotifier, executorService, scheduledExecutorService, readOnlyStreamInformationStore, rtpReceiverEventHandler, logger, diagnosticContext);
        relayedEndpoint = this;
        boolean bl2 = false;
        $this$rtpReceiver_u24lambda_u2d2.setPacketHandler(new ConsumerNode(id, conference){
            final /* synthetic */ String $id;
            final /* synthetic */ Conference $conference;
            {
                this.$id = $id;
                this.$conference = $conference;
                super("receiver chain handler");
            }

            protected void consume(@NotNull PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                packetInfo.setEndpointId(this.$id);
                this.$conference.handleIncomingPacket(packetInfo);
            }

            public void trace(@NotNull Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        });
        $this$rtpReceiver_u24lambda_u2d2.handleEvent(new SetLocalSsrcEvent(MediaType.AUDIO, conference.getLocalAudioSsrc()));
        $this$rtpReceiver_u24lambda_u2d2.handleEvent(new SetLocalSsrcEvent(MediaType.VIDEO, conference.getLocalVideoSsrc()));
        relayedEndpoint.rtpReceiver = object;
        this._mediaSources = new MediaSources();
    }

    @NotNull
    public final Relay getRelay() {
        return this.relay;
    }

    @NotNull
    public final AudioSourceDesc[] getAudioSources() {
        return this.audioSources;
    }

    public final void setAudioSources(@NotNull AudioSourceDesc[] value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.audioSources = value2;
        AudioSourceDesc[] $this$forEach$iv = value2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            AudioSourceDesc element$iv;
            AudioSourceDesc it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.streamInformationStore.addReceiveSsrc(it.getSsrc(), MediaType.AUDIO);
            this.getConference().addEndpointSsrc(this, it.getSsrc());
        }
    }

    @NotNull
    public final RtcpEventNotifier getRtcpEventNotifier() {
        return this.rtcpEventNotifier;
    }

    @Override
    public boolean receivesSsrc(long ssrc2) {
        return this.streamInformationStore.getReceiveSsrcs().contains(ssrc2);
    }

    @NotNull
    public HashSet<Long> getSsrcs() {
        return new HashSet<Long>((Collection)this.streamInformationStore.getReceiveSsrcs());
    }

    public final boolean hasReceiveSsrcs() {
        return !((Collection)this.streamInformationStore.getReceiveSsrcs()).isEmpty();
    }

    @Override
    public boolean shouldExpire() {
        return false;
    }

    @Override
    public void requestKeyframe(long mediaSsrc) {
        this.relay.getTransceiver().requestKeyFrame(mediaSsrc);
    }

    @Override
    public void requestKeyframe() {
        MediaSourceDesc mediaSourceDesc = this.getMediaSource();
        this.relay.getTransceiver().requestKeyFrame(mediaSourceDesc != null ? Long.valueOf(mediaSourceDesc.getPrimarySSRC()) : null);
    }

    @Override
    public boolean isSendingAudio() {
        return this.rtpReceiver.isReceivingAudio();
    }

    @Override
    public boolean isSendingVideo() {
        return this.rtpReceiver.isReceivingVideo();
    }

    @Override
    public void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.streamInformationStore.addRtpPayloadType(payloadType);
    }

    @Override
    public void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        this.streamInformationStore.addRtpExtensionMapping(rtpExtension);
    }

    public void setExtmapAllowMixed(boolean allow) {
        this.streamInformationStore.setExtmapAllowMixed(allow);
    }

    @Override
    protected void sendVideoConstraints(@NotNull VideoConstraints maxVideoConstraints) {
        Intrinsics.checkNotNullParameter(maxVideoConstraints, "maxVideoConstraints");
        this.relay.sendMessage(new AddReceiverMessage(RelayConfig.config.getRelayId(), this.getId(), null, maxVideoConstraints));
    }

    @Override
    protected void sendVideoConstraintsV2(@NotNull String sourceName, @NotNull VideoConstraints maxVideoConstraints) {
        Intrinsics.checkNotNullParameter(sourceName, "sourceName");
        Intrinsics.checkNotNullParameter(maxVideoConstraints, "maxVideoConstraints");
        this.relay.sendMessage(new AddReceiverMessage(RelayConfig.config.getRelayId(), null, sourceName, maxVideoConstraints));
    }

    public final void relayMessageTransportConnected() {
        Map map = this.maxReceiverVideoConstraintsMap;
        Intrinsics.checkNotNullExpressionValue(map, "maxReceiverVideoConstraintsMap");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String sourceName = (String)entry.getKey();
            VideoConstraints constraints = (VideoConstraints)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(sourceName, "sourceName");
            Intrinsics.checkNotNullExpressionValue(constraints, "constraints");
            this.sendVideoConstraintsV2(sourceName, constraints);
        }
    }

    @Override
    @NotNull
    public MediaSourceDesc[] getMediaSources() {
        return this._mediaSources.getMediaSources();
    }

    public void setMediaSources(@NotNull MediaSourceDesc[] value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.applyVideoTypeCache(value2);
        boolean changed = this._mediaSources.setMediaSources(value2);
        MediaSourceDesc[] mergedMediaSources = this._mediaSources.getMediaSources();
        MediaSourceDesc[] signaledMediaSources = MediaSourceDescKt.copy(value2);
        if (changed) {
            SetMediaSourcesEvent setMediaSourcesEvent = new SetMediaSourcesEvent(this.getMediaSources(), signaledMediaSources);
            this.rtpReceiver.handleEvent(setMediaSourcesEvent);
            MediaSourceDesc[] $this$forEach$iv = this.getMediaSources();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                RtpEncodingDesc[] $this$forEach$iv2 = it.getRtpEncodings();
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    RtpEncodingDesc element$iv2;
                    RtpEncodingDesc it2 = element$iv2 = $this$forEach$iv2[j];
                    boolean bl2 = false;
                    Iterable $this$forEach$iv3 = it2.getSsrcs();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        long it3 = ((Number)element$iv3).longValue();
                        boolean bl3 = false;
                        this.streamInformationStore.addReceiveSsrc(it3, MediaType.VIDEO);
                        this.getConference().addEndpointSsrc(this, it3);
                    }
                }
            }
        }
    }

    public final void setSrtpInformation(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.rtpReceiver.setSrtpTransformers(srtpTransformers);
    }

    @Override
    public void handleIncomingPacket(@NotNull RelayedPacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        this.rtpReceiver.processPacket(packetInfo);
    }

    public final void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        this.rtpReceiver.setFeature(feature, enabled2);
    }

    @NotNull
    public final PacketStreamStats.Snapshot getIncomingStats() {
        return this.rtpReceiver.getStats().getPacketStreamStats();
    }

    @NotNull
    public final NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d7 = nodeStatsBlock = new NodeStatsBlock("Remote Endpoint " + this.getId());
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d7.addBlock(this.streamInformationStore.getNodeStats());
        $this$getNodeStats_u24lambda_u2d7.addBlock(this._mediaSources.getNodeStats());
        $this$getNodeStats_u24lambda_u2d7.addBlock(this.rtpReceiver.getNodeStats());
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$getDebugState_u24lambda_u2d8 = jSONObject = super.getDebugState();
        boolean bl = false;
        NodeStatsBlock block = this.getNodeStats();
        $this$getDebugState_u24lambda_u2d8.put(block.getName(), block.toJson());
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkNotNullExpressionValue(jSONObject2, "super.getDebugState().ap\u2026block.toJson())\n        }");
        return jSONObject2;
    }

    private final void updateStatsOnExpire() {
        Relay.Statistics statistics;
        Relay.Statistics relayStats = this.relay.getStatistics();
        RtpReceiverStats rtpReceiverStats = this.rtpReceiver.getStats();
        PacketStreamStats.Snapshot incomingStats = rtpReceiverStats.getPacketStreamStats();
        Relay.Statistics $this$updateStatsOnExpire_u24lambda_u2d9 = statistics = relayStats;
        boolean bl = false;
        $this$updateStatsOnExpire_u24lambda_u2d9.getBytesReceived().getAndAdd(incomingStats.getBytes());
        $this$updateStatsOnExpire_u24lambda_u2d9.getPacketsReceived().getAndAdd(incomingStats.getPackets());
    }

    @Override
    public void expire() {
        if (super.isExpired()) {
            return;
        }
        super.expire();
        try {
            this.updateStatsOnExpire();
            this.rtpReceiver.stop();
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            Logger $this$cdebug$iv = logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger2 = $this$cdebug$iv;
                boolean bl = false;
                logger2.debug(this.getNodeStats().prettyPrint(0));
            }
            this.rtpReceiver.tearDown();
        }
        catch (Throwable t) {
            this.logger.error("Exception while expiring: ", t);
        }
        this.logger.info("Expired.");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/relay/RelayedEndpoint$RtpReceiverEventHandlerImpl;", "Lorg/jitsi/nlj/RtpReceiverEventHandler;", "(Lorg/jitsi/videobridge/relay/RelayedEndpoint;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "jitsi-videobridge"})
    private final class RtpReceiverEventHandlerImpl
    implements RtpReceiverEventHandler {
        @Override
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            return RelayedEndpoint.this.getConference().levelChanged(RelayedEndpoint.this, level);
        }

        @Override
        public void bandwidthEstimationChanged-_2icLw0(double newValue) {
            Logger logger = RelayedEndpoint.this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            Logger $this$cdebug$iv = logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger2 = $this$cdebug$iv;
                boolean bl = false;
                logger2.debug("Estimated bandwidth is now " + Bandwidth.toString-impl(newValue));
            }
        }
    }
}

