/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;

public class MUCUser
implements ExtensionElement {
    public static final String ELEMENT = "x";
    public static final String NAMESPACE = "http://jabber.org/protocol/muc#user";
    public static final QName QNAME = new QName("http://jabber.org/protocol/muc#user", "x");
    private final Set<Status> statusCodes = new HashSet<Status>(4);
    private Invite invite;
    private Decline decline;
    private MUCItem item;
    private String password;
    private Destroy destroy;

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.rightAngleBracket();
        xml.optElement(this.getInvite());
        xml.optElement(this.getDecline());
        xml.optElement(this.getItem());
        xml.optElement("password", this.getPassword());
        xml.append(this.statusCodes);
        xml.optElement(this.getDestroy());
        xml.closeElement(this);
        return xml;
    }

    public Invite getInvite() {
        return this.invite;
    }

    public Decline getDecline() {
        return this.decline;
    }

    public MUCItem getItem() {
        return this.item;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Status> getStatus() {
        return this.statusCodes;
    }

    public boolean hasStatus() {
        return !this.statusCodes.isEmpty();
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setInvite(Invite invite) {
        this.invite = invite;
    }

    public void setDecline(Decline decline) {
        this.decline = decline;
    }

    public void setItem(MUCItem item) {
        this.item = item;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void addStatusCodes(Set<Status> statusCodes) {
        this.statusCodes.addAll(statusCodes);
    }

    public void addStatusCode(Status status) {
        this.statusCodes.add(status);
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    @Deprecated
    public static MUCUser getFrom(Stanza packet) {
        return MUCUser.from(packet);
    }

    public static MUCUser from(Stanza packet) {
        return packet.getExtension(MUCUser.class);
    }

    public static final class Status
    implements NamedElement {
        public static final String ELEMENT = "status";
        private static final Map<Integer, Status> statusMap = new HashMap<Integer, Status>(8);
        public static final Status PRESENCE_TO_SELF_110 = Status.create(110);
        public static final Status ROOM_CREATED_201 = Status.create(201);
        public static final Status BANNED_301 = Status.create(301);
        public static final Status NEW_NICKNAME_303 = Status.create(303);
        public static final Status KICKED_307 = Status.create(307);
        public static final Status REMOVED_AFFIL_CHANGE_321 = Status.create(321);
        public static final Status REMOVED_FOR_TECHNICAL_REASONS_333 = Status.create(333);
        private final Integer code;

        public static Status create(String string) {
            Integer integer = Integer.valueOf(string);
            return Status.create(integer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Status create(Integer i) {
            Status status;
            Map<Integer, Status> map = statusMap;
            synchronized (map) {
                status = statusMap.get(i);
                if (status == null) {
                    status = new Status(i);
                    statusMap.put(i, status);
                }
            }
            return status;
        }

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this);
            xml.attribute("code", this.getCode());
            xml.closeEmptyElement();
            return xml;
        }

        public String toString() {
            return this.code.toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Status) {
                Status otherStatus = (Status)other;
                return this.code.equals(otherStatus.getCode());
            }
            return false;
        }

        public int hashCode() {
            return this.code;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Decline
    implements ExtensionElement {
        public static final String ELEMENT = "decline";
        public static final QName QNAME = new QName("http://jabber.org/protocol/muc#user", "decline");
        private final String reason;
        private final EntityBareJid from;
        private final EntityBareJid to;

        public Decline(String reason2, EntityBareJid to) {
            this(reason2, null, to);
        }

        public Decline(String reason2, EntityBareJid from, EntityBareJid to) {
            this.reason = reason2;
            this.from = from;
            this.to = to;
        }

        public EntityBareJid getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public EntityBareJid getTo() {
            return this.to;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
            xml.optAttribute("to", this.getTo());
            xml.optAttribute("from", this.getFrom());
            xml.rightAngleBracket();
            xml.optElement("reason", this.getReason());
            xml.closeElement(this);
            return xml;
        }

        @Override
        public String getElementName() {
            return QNAME.getLocalPart();
        }

        @Override
        public String getNamespace() {
            return QNAME.getNamespaceURI();
        }
    }

    public static class Invite
    implements NamedElement {
        public static final String ELEMENT = "invite";
        private final String reason;
        private final EntityJid from;
        private final EntityBareJid to;

        public Invite(String reason2, EntityFullJid from) {
            this(reason2, from, null);
        }

        public Invite(String reason2, EntityBareJid to) {
            this(reason2, null, to);
        }

        public Invite(String reason2, EntityJid from, EntityBareJid to) {
            this.reason = reason2;
            this.from = from;
            this.to = to;
        }

        public EntityJid getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public EntityBareJid getTo() {
            return this.to;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this);
            xml.optAttribute("to", this.getTo());
            xml.optAttribute("from", this.getFrom());
            xml.rightAngleBracket();
            xml.optElement("reason", this.getReason());
            xml.closeElement(this);
            return xml;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }
}

