/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Dot11SequenceControl
implements Serializable {
    private static final long serialVersionUID = 8383319258993027L;
    private final byte fragmentNumber;
    private final short sequenceNumber;

    public static Dot11SequenceControl newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11SequenceControl(rawData, offset, length);
    }

    private Dot11SequenceControl(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a Dot11SequenceControl (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.fragmentNumber = (byte)(rawData[offset] & 0xF);
        this.sequenceNumber = (short)(ByteArrays.getShort(rawData, offset, ByteOrder.LITTLE_ENDIAN) >> 4 & 0xFFF);
    }

    private Dot11SequenceControl(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        if ((builder2.fragmentNumber & 0xF0) != 0) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("(builder.fragmentNumber & 0xF0) must be zero. builder.fragmentNumber: ").append(builder2.fragmentNumber);
            throw new IllegalArgumentException(sb.toString());
        }
        if ((builder2.sequenceNumber & 0xF000) != 0) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("(builder.sequenceNumber & 0xF000) must be zero. builder.sequenceNumber: ").append(builder2.sequenceNumber);
            throw new IllegalArgumentException(sb.toString());
        }
        this.fragmentNumber = builder2.fragmentNumber;
        this.sequenceNumber = builder2.sequenceNumber;
    }

    public byte getFragmentNumber() {
        return this.fragmentNumber;
    }

    public int getFragmentNumberAsInt() {
        return this.fragmentNumber;
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getSequenceNumberAsInt() {
        return this.sequenceNumber;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data2 = ByteArrays.toByteArray((short)(this.sequenceNumber << 4), ByteOrder.LITTLE_ENDIAN);
        data2[0] = (byte)(data2[0] | this.fragmentNumber);
        return data2;
    }

    public int length() {
        return 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("[Fragment Number: ").append(this.getFragmentNumberAsInt()).append(", Sequence Number: ").append(this.getSequenceNumberAsInt()).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.fragmentNumber;
        result2 = 31 * result2 + this.sequenceNumber;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11SequenceControl other = (Dot11SequenceControl)obj;
        if (this.fragmentNumber != other.fragmentNumber) {
            return false;
        }
        return this.sequenceNumber == other.sequenceNumber;
    }

    public static final class Builder {
        private byte fragmentNumber;
        private short sequenceNumber;

        public Builder() {
        }

        private Builder(Dot11SequenceControl obj) {
            this.fragmentNumber = obj.fragmentNumber;
            this.sequenceNumber = obj.sequenceNumber;
        }

        public Builder fragmentNumber(byte fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
            return this;
        }

        public Builder sequenceNumber(short sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Dot11SequenceControl build() {
            return new Dot11SequenceControl(this);
        }
    }
}

