/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PreferencesAction
extends JosmAction
implements Runnable {
    private final Class<? extends TabPreferenceSetting> tab;
    private final Class<? extends SubPreferenceSetting> subTab;

    private PreferencesAction(String name, String icon, String tooltip, Class<? extends TabPreferenceSetting> tab, Class<? extends SubPreferenceSetting> subTab) {
        super(name, icon, tooltip, null, false, "preference_" + Utils.firstNonNull(tab, subTab).getName(), false);
        this.tab = tab;
        this.subTab = subTab;
    }

    public static PreferencesAction forPreferenceTab(String name, String tooltip, Class<? extends TabPreferenceSetting> tab) {
        return PreferencesAction.forPreferenceTab(name, tooltip, tab, "preference");
    }

    public static PreferencesAction forPreferenceTab(String name, String tooltip, Class<? extends TabPreferenceSetting> tab, String icon) {
        CheckParameterUtil.ensureParameterNotNull(tab);
        return new PreferencesAction(name, icon, tooltip, tab, null);
    }

    public static PreferencesAction forPreferenceSubTab(String name, String tooltip, Class<? extends SubPreferenceSetting> subTab) {
        return PreferencesAction.forPreferenceSubTab(name, tooltip, subTab, "preference");
    }

    public static PreferencesAction forPreferenceSubTab(String name, String tooltip, Class<? extends SubPreferenceSetting> subTab, String icon) {
        CheckParameterUtil.ensureParameterNotNull(subTab);
        return new PreferencesAction(name, icon, tooltip, null, subTab);
    }

    public PreferencesAction() {
        super(I18n.tr("Preferences...", new Object[0]), "preference", I18n.tr("Open a preferences dialog for global settings.", new Object[0]), Shortcut.registerShortcut("system:preferences", I18n.tr("Preferences", new Object[0]), 123, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/Preferences"));
        this.tab = null;
        this.subTab = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    @Override
    public void run() {
        PreferenceDialog p = new PreferenceDialog((Component)MainApplication.getMainFrame());
        if (this.tab != null) {
            p.selectPreferencesTabByClass(this.tab);
        } else if (this.subTab != null) {
            p.selectSubPreferencesTabByClass(this.subTab);
        }
        p.setVisible(true);
    }
}

