/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public class ParallelWays {
    private final List<Way> ways;
    private final List<Node> sortedNodes;
    private final int nodeCount;
    private final EastNorth[] pts;
    private final EastNorth[] normals;

    public ParallelWays(Collection<Way> sourceWays, boolean copyTags, int refWayIndex) {
        int i;
        HashMap<Node, Node> splitNodeMap = new HashMap<Node, Node>(sourceWays.size());
        for (Way w : sourceWays) {
            ParallelWays.copyNodeInMap(splitNodeMap, w.firstNode(), copyTags);
            ParallelWays.copyNodeInMap(splitNodeMap, w.lastNode(), copyTags);
        }
        this.ways = new ArrayList<Way>(sourceWays.size());
        for (Way w : sourceWays) {
            Way wCopy = new Way();
            wCopy.addNode((Node)splitNodeMap.get(w.firstNode()));
            for (int i2 = 1; i2 < w.getNodesCount() - 1; ++i2) {
                wCopy.addNode(ParallelWays.copyNode(w.getNode(i2), copyTags));
            }
            wCopy.addNode((Node)splitNodeMap.get(w.lastNode()));
            if (copyTags) {
                wCopy.setKeys(w.getKeys());
            }
            this.ways.add(wCopy);
        }
        NodeGraph nodeGraph = NodeGraph.createUndirectedGraphFromNodeWays(this.ways);
        List<Node> sortedNodesPath = nodeGraph.buildSpanningPath();
        if (sortedNodesPath == null) {
            throw new IllegalArgumentException("Ways must have spanning path");
        }
        HashSet<Node> removedNodes = new HashSet<Node>();
        this.sortedNodes = new ArrayList<Node>();
        for (int i2 = 0; i2 < sortedNodesPath.size(); ++i2) {
            Node n = sortedNodesPath.get(i2);
            if (i2 < sortedNodesPath.size() - 1 && sortedNodesPath.get(i2 + 1).getCoor().equals(n.getCoor())) {
                removedNodes.add(n);
                for (Way way : this.ways) {
                    way.removeNode(n);
                }
                continue;
            }
            if (removedNodes.contains(n)) continue;
            this.sortedNodes.add(n);
        }
        Way refWay = this.ways.get(refWayIndex);
        boolean refWayReversed = true;
        for (i = 0; i < this.sortedNodes.size() - 1; ++i) {
            if (this.sortedNodes.get(i) != refWay.firstNode() || this.sortedNodes.get(i + 1) != refWay.getNode(1)) continue;
            refWayReversed = false;
            break;
        }
        if (refWayReversed) {
            Collections.reverse(this.sortedNodes);
        }
        this.nodeCount = this.sortedNodes.size();
        this.pts = new EastNorth[this.nodeCount];
        this.normals = new EastNorth[this.nodeCount - 1];
        i = 0;
        for (Node n : this.sortedNodes) {
            EastNorth t;
            this.pts[i] = t = n.getEastNorth();
            ++i;
        }
        for (i = 0; i < this.nodeCount - 1; ++i) {
            double d = this.pts[i + 1].getX() - this.pts[i].getX();
            double dy = this.pts[i + 1].getY() - this.pts[i].getY();
            double len = Math.sqrt(d * d + dy * dy);
            this.normals[i] = new EastNorth(-dy / len, d / len);
        }
    }

    private static void copyNodeInMap(Map<Node, Node> splitNodeMap, Node node, boolean copyTags) {
        if (!splitNodeMap.containsKey(node)) {
            splitNodeMap.put(node, ParallelWays.copyNode(node, copyTags));
        }
    }

    public boolean isClosedPath() {
        return this.sortedNodes.get(0) == this.sortedNodes.get(this.sortedNodes.size() - 1);
    }

    public void changeOffset(double d) {
        EastNorth[] ppts = new EastNorth[this.nodeCount];
        EastNorth prevA = this.pts[0].add(this.normals[0].scale(d));
        EastNorth prevB = this.pts[1].add(this.normals[0].scale(d));
        for (int i = 1; i < this.nodeCount - 1; ++i) {
            EastNorth b;
            EastNorth a = this.pts[i].add(this.normals[i].scale(d));
            ppts[i] = Geometry.segmentsParallel(a, b = this.pts[i + 1].add(this.normals[i].scale(d)), prevA, prevB) ? a : Geometry.getLineLineIntersection(a, b, prevA, prevB);
            prevA = a;
            prevB = b;
        }
        if (this.isClosedPath()) {
            EastNorth b;
            EastNorth a = this.pts[0].add(this.normals[0].scale(d));
            ppts[0] = Geometry.segmentsParallel(a, b = this.pts[1].add(this.normals[0].scale(d)), prevA, prevB) ? a : Geometry.getLineLineIntersection(a, b, prevA, prevB);
            ppts[this.nodeCount - 1] = ppts[0];
        } else {
            ppts[0] = this.pts[0].add(this.normals[0].scale(d));
            ppts[this.nodeCount - 1] = this.pts[this.nodeCount - 1].add(this.normals[this.nodeCount - 2].scale(d));
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            this.sortedNodes.get(i).setEastNorth(ppts[i]);
        }
    }

    public void commit() {
        UndoRedoHandler.getInstance().add(new SequenceCommand("Make parallel way(s)", this.makeAddWayAndNodesCommandList()));
    }

    private List<Command> makeAddWayAndNodesCommandList() {
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        ArrayList<Command> commands = new ArrayList<Command>(this.sortedNodes.size() + this.ways.size());
        for (int i = 0; i < this.sortedNodes.size() - (this.isClosedPath() ? 1 : 0); ++i) {
            commands.add(new AddCommand(ds, this.sortedNodes.get(i)));
        }
        for (Way w : this.ways) {
            commands.add(new AddCommand(ds, w));
        }
        return commands;
    }

    private static Node copyNode(Node source, boolean copyTags) {
        if (copyTags) {
            return new Node(source, true);
        }
        Node n = new Node();
        n.setCoor(source.getCoor());
        return n;
    }

    public final List<Way> getWays() {
        return this.ways;
    }
}

