/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeNodesCommand
extends Command {
    private final Way way;
    private final List<Node> newNodes;

    public ChangeNodesCommand(Way way, List<Node> newNodes) {
        this(way.getDataSet(), way, newNodes);
    }

    public ChangeNodesCommand(DataSet ds, Way way, List<Node> newNodes) {
        super(ds);
        this.way = way;
        this.newNodes = newNodes;
        if (newNodes.isEmpty()) {
            throw new IllegalArgumentException("Cannot set nodes to be an empty list.");
        }
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.way.setNodes(this.newNodes);
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.way);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Change nodes of {0}", this.way.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(OsmPrimitiveType.WAY);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.way, this.newNodes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChangeNodesCommand that = (ChangeNodesCommand)obj;
        return Objects.equals(this.way, that.way) && Objects.equals(this.newNodes, that.newNodes);
    }
}

