/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;

public class AllNodesVisitor
implements OsmPrimitiveVisitor {
    public Collection<Node> nodes = new HashSet<Node>();

    @Override
    public void visit(Node n) {
        this.nodes.add(n);
    }

    @Override
    public void visit(Way w) {
        if (w.isIncomplete()) {
            return;
        }
        for (Node n : w.getNodes()) {
            this.visit(n);
        }
    }

    @Override
    public void visit(Relation e) {
        for (RelationMember m : e.getMembers()) {
            if (!m.isNode()) continue;
            this.visit(m.getNode());
        }
    }

    public static Collection<Node> getAllNodes(Collection<? extends OsmPrimitive> osms) {
        AllNodesVisitor v = new AllNodesVisitor();
        for (OsmPrimitive osmPrimitive : osms) {
            osmPrimitive.accept(v);
        }
        return v.nodes;
    }
}

