/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.data.preferences.AbstractProperty;

public class CachingProperty<T>
extends AbstractProperty<T>
implements AbstractProperty.ValueChangeListener<T> {
    private T cache;
    private boolean cacheValid;
    private final AbstractProperty<T> toCache;

    CachingProperty(AbstractProperty<T> toCache) {
        super(toCache.getKey(), toCache.getDefaultValue());
        this.toCache = toCache;
        this.addWeakListener(this);
    }

    @Override
    public synchronized T get() {
        if (!this.cacheValid) {
            this.cache = this.toCache.get();
            this.cacheValid = true;
        }
        return this.cache;
    }

    @Override
    public boolean put(T value) {
        return this.toCache.put(value);
    }

    @Override
    public synchronized void valueChanged(AbstractProperty.ValueChangeEvent<? extends T> e) {
        this.cacheValid = false;
    }
}

