/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;

public class ThreeParameterDatum
extends AbstractDatum {
    protected double dx;
    protected double dy;
    protected double dz;

    public ThreeParameterDatum(String name, String proj4Id, Ellipsoid ellps, double dx, double dy, double dz) {
        super(name, proj4Id, ellps);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    @Override
    public LatLon toWGS84(LatLon ll) {
        double[] xyz = this.ellps.latLon2Cart(ll);
        xyz[0] = xyz[0] + this.dx;
        xyz[1] = xyz[1] + this.dy;
        xyz[2] = xyz[2] + this.dz;
        return Ellipsoid.WGS84.cart2LatLon(xyz);
    }

    @Override
    public LatLon fromWGS84(LatLon ll) {
        double[] xyz = Ellipsoid.WGS84.latLon2Cart(ll);
        xyz[0] = xyz[0] - this.dx;
        xyz[1] = xyz[1] - this.dy;
        xyz[2] = xyz[2] - this.dz;
        return this.ellps.cart2LatLon(xyz);
    }
}

