/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.correction;

import java.util.List;
import org.openstreetmap.josm.data.correction.TagCorrection;
import org.openstreetmap.josm.gui.correction.CorrectionTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TagCorrectionTableModel
extends CorrectionTableModel<TagCorrection> {
    public TagCorrectionTableModel(List<TagCorrection> tagCorrections) {
        super(tagCorrections);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getCorrectionColumnName(int colIndex) {
        switch (colIndex) {
            case 0: {
                return I18n.tr("Old key", new Object[0]);
            }
            case 1: {
                return I18n.tr("Old value", new Object[0]);
            }
            case 2: {
                return I18n.tr("New key", new Object[0]);
            }
            case 3: {
                return I18n.tr("New value", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public Object getCorrectionValueAt(int rowIndex, int colIndex) {
        TagCorrection tagCorrection = (TagCorrection)this.getCorrections().get(rowIndex);
        switch (colIndex) {
            case 0: {
                return tagCorrection.oldKey;
            }
            case 1: {
                return tagCorrection.oldValue;
            }
            case 2: {
                return tagCorrection.newKey;
            }
            case 3: {
                return tagCorrection.newValue;
            }
        }
        return null;
    }

    @Override
    protected boolean isBoldCell(int row, int column) {
        TagCorrection tagCorrection = (TagCorrection)this.getCorrections().get(row);
        return column == 2 && tagCorrection.isKeyChanged() || column == 3 && tagCorrection.isValueChanged();
    }
}

