/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.function.Function;

public class MultiLineFlowLayout
extends FlowLayout {
    public MultiLineFlowLayout() {
    }

    public MultiLineFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    public MultiLineFlowLayout(int align) {
        super(align);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.getLayoutSize(target, Component::getPreferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.getLayoutSize(target, Component::getMinimumSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container target, Function<Component, Dimension> baseSize) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int outerWidth = MultiLineFlowLayout.getWidthOf(target);
            Insets insets = target.getInsets();
            int containerWidth = outerWidth - insets.left - insets.right - this.getHgap() * 2;
            int x = 0;
            int totalHeight = insets.top + insets.bottom + this.getVgap() * 2;
            int rowHeight = 0;
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component child = target.getComponent(i);
                if (!child.isVisible()) continue;
                Dimension size = baseSize.apply(child);
                if (x != 0) {
                    x += this.getHgap();
                }
                if ((x += size.width) > containerWidth) {
                    totalHeight += rowHeight + this.getVgap();
                    rowHeight = 0;
                    x = 0;
                }
                rowHeight = Math.max(rowHeight, size.height);
            }
            return new Dimension(outerWidth, totalHeight += rowHeight);
        }
    }

    private static int getWidthOf(Container target) {
        Container current = target;
        while (current.getWidth() == 0 && current.getParent() != null) {
            current = current.getParent();
        }
        int width = current.getWidth();
        if (width == 0) {
            return Integer.MAX_VALUE;
        }
        return width;
    }

    @Override
    public String toString() {
        return "MultiLineFlowLayout [align=" + this.getAlignment() + ']';
    }
}

