/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.widgets.JosmTextField;

public abstract class SearchTextResultListPanel<T>
extends JPanel {
    protected final JosmTextField edSearchText;
    protected final JList<T> lsResult;
    protected final ResultListModel<T> lsResultModel = new ResultListModel();
    protected final transient List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    private transient ActionListener dblClickListener;
    private transient ActionListener clickListener;

    protected abstract void filterItems();

    public SearchTextResultListPanel() {
        super(new BorderLayout());
        this.edSearchText = new JosmTextField();
        this.edSearchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchTextResultListPanel.this.filterItems();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchTextResultListPanel.this.filterItems();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchTextResultListPanel.this.filterItems();
            }
        });
        this.edSearchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() + 1);
                        break;
                    }
                    case 38: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() - 1);
                        break;
                    }
                    case 34: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() + 10);
                        break;
                    }
                    case 33: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResult.getSelectedIndex() - 10);
                        break;
                    }
                    case 36: {
                        SearchTextResultListPanel.this.selectItem(0);
                        break;
                    }
                    case 35: {
                        SearchTextResultListPanel.this.selectItem(SearchTextResultListPanel.this.lsResultModel.getSize());
                        break;
                    }
                }
            }
        });
        this.add((Component)this.edSearchText, "North");
        this.lsResult = new JList<T>(this.lsResultModel);
        this.lsResult.setSelectionMode(0);
        this.lsResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    if (SearchTextResultListPanel.this.dblClickListener != null) {
                        SearchTextResultListPanel.this.dblClickListener.actionPerformed(null);
                    }
                } else if (SearchTextResultListPanel.this.clickListener != null) {
                    SearchTextResultListPanel.this.clickListener.actionPerformed(null);
                }
            }
        });
        this.add((Component)new JScrollPane(this.lsResult), "Center");
    }

    public synchronized void init() {
        this.listSelectionListeners.clear();
        this.edSearchText.setText("");
        this.filterItems();
    }

    private synchronized void selectItem(int newIndex) {
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex > this.lsResultModel.getSize() - 1) {
            newIndex = this.lsResultModel.getSize() - 1;
        }
        this.lsResult.setSelectedIndex(newIndex);
        this.lsResult.ensureIndexIsVisible(newIndex);
    }

    public synchronized void clearSelection() {
        this.lsResult.clearSelection();
    }

    public synchronized int getItemCount() {
        return this.lsResultModel.getSize();
    }

    public void setDblClickListener(ActionListener dblClickListener) {
        this.dblClickListener = dblClickListener;
    }

    public void setClickListener(ActionListener clickListener) {
        this.clickListener = clickListener;
    }

    public synchronized void addSelectionListener(ListSelectionListener selectListener) {
        this.lsResult.getSelectionModel().addListSelectionListener(selectListener);
        this.listSelectionListeners.add(selectListener);
    }

    public synchronized void removeSelectionListener(ListSelectionListener selectListener) {
        this.listSelectionListeners.remove(selectListener);
        this.lsResult.getSelectionModel().removeListSelectionListener(selectListener);
    }

    protected static class ResultListModel<T>
    extends AbstractListModel<T> {
        private transient List<T> items = new ArrayList<T>();

        protected ResultListModel() {
        }

        public synchronized void setItems(List<T> items) {
            this.items = items;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        @Override
        public synchronized T getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public synchronized int getSize() {
            return this.items.size();
        }

        public synchronized boolean isEmpty() {
            return this.items.isEmpty();
        }
    }
}

