/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;

public class SubclassFilteredCollection<S, T extends S>
extends AbstractCollection<T> {
    private final Collection<? extends S> collection;
    private final Predicate<? super S> predicate;
    private int size = -1;

    public SubclassFilteredCollection(Collection<? extends S> collection, Predicate<? super S> predicate) {
        this.collection = Objects.requireNonNull(collection);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator(this.collection.iterator());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<T> it = this.iterator();
            while (it.hasNext()) {
                ++this.size;
                it.next();
            }
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public static <T> SubclassFilteredCollection<T, T> filter(Collection<? extends T> collection, Predicate<T> predicate) {
        return new SubclassFilteredCollection<T, T>(collection, predicate);
    }

    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<? extends S> iterator;
        private S current;

        FilterIterator(Iterator<? extends S> iterator) {
            this.iterator = iterator;
        }

        private void findNext() {
            if (this.current == null) {
                while (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    if (!SubclassFilteredCollection.this.predicate.test(this.current)) continue;
                    return;
                }
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.current != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object old = this.current;
            this.current = null;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

