/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.logmanager.NDCProvider;
import org.jboss.logmanager.ThreadLocalNDC;

public final class NDC {
    private static final NDCProvider ndcProvider = NDC.getNDCProvider();

    private NDC() {
    }

    static NDCProvider getNDCProvider() {
        ServiceLoader<NDCProvider> configLoader = ServiceLoader.load(NDCProvider.class, NDC.class.getClassLoader());
        Iterator<NDCProvider> iterator = configLoader.iterator();
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return new ThreadLocalNDC();
                }
                return iterator.next();
            }
            catch (RuntimeException | ServiceConfigurationError e) {
                System.err.print("Warning: failed to load NDC Provider: ");
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public static int push(String context) {
        return ndcProvider.push(context);
    }

    public static String pop() {
        return ndcProvider.pop();
    }

    public static void clear() {
        ndcProvider.clear();
    }

    public static void trimTo(int size) {
        ndcProvider.trimTo(size);
    }

    public static int getDepth() {
        return ndcProvider.getDepth();
    }

    public static String get() {
        return ndcProvider.get();
    }

    public static String get(int n) {
        return ndcProvider.get(n);
    }
}

