/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.type.TypeHelper;

public class NewTriggerAdapter
extends RuleTriggerAdapter {
    protected String typeName;
    protected int count;
    protected boolean whenComplete;

    public NewTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String typeName, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.typeName = typeName;
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new NewTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new NewTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class NewTriggerConstructorAdapter
    extends NewTriggerMethodAdapter {
        NewTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.latched && NewTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name)) {
                this.latched = false;
            }
        }
    }

    private class NewTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;
        private int visitedCount;
        private boolean triggerReady;
        private String matchedBaseName;

        NewTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.visitedCount = 0;
            this.latched = false;
            this.triggerReady = false;
            this.matchedBaseName = null;
        }

        @Override
        public String getNewClassName() {
            return this.matchedBaseName;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (this.triggerReady && opcode == 183 && name.equals("<init>")) {
                if (!this.latched) {
                    this.injectTriggerPoint();
                } else {
                    this.transformContext.warn(name, descriptor, "cannot inject AFTER NEW rule into constructor before super constructor has been called");
                }
                this.triggerReady = false;
            }
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187 && (NewTriggerAdapter.this.count == 0 || this.visitedCount < NewTriggerAdapter.this.count) && this.matchType(type)) {
                ++this.visitedCount;
                if (NewTriggerAdapter.this.count == 0 || this.visitedCount == NewTriggerAdapter.this.count) {
                    if (NewTriggerAdapter.this.whenComplete) {
                        this.triggerReady = true;
                    } else if (!this.latched) {
                        this.injectTriggerPoint();
                    } else {
                        this.transformContext.warn(this.name, this.descriptor, "cannot inject AT NEW rule into constructor before super constructor has been called");
                    }
                }
            }
            super.visitTypeInsn(opcode, type);
        }

        private boolean matchType(String type) {
            String baseName = TypeHelper.internalizeClass(type, true);
            boolean matched = false;
            if (NewTriggerAdapter.this.typeName.length() == 0) {
                matched = true;
            } else if (NewTriggerAdapter.this.typeName.equals(baseName)) {
                matched = true;
            } else if (!NewTriggerAdapter.this.typeName.contains(".") && baseName.contains(".")) {
                int tailIdx = baseName.lastIndexOf(".");
                matched = NewTriggerAdapter.this.typeName.equals(baseName.substring(tailIdx + 1));
            }
            if (matched) {
                this.matchedBaseName = baseName;
            }
            return matched;
        }

        @Override
        public Type getReturnBindingType() {
            return Type.getObjectType(TypeHelper.externalizeClass(this.getNewClassName()));
        }
    }
}

