/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.compiler;

import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.Type;

public class CompileContext {
    private int sourceLine = -1;
    private int stackCount = 0;
    private int stackMax = 0;
    private int localCount = 0;
    private int localMax = 0;
    private MethodVisitor mv;

    CompileContext(MethodVisitor mv) {
        this.mv = mv;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public int getLocalCount() {
        return this.localCount;
    }

    public int getStackMax() {
        return this.stackMax;
    }

    public int getLocalMax() {
        return this.localMax;
    }

    public void addStackCount(int count) {
        this.stackCount += count;
        if (this.stackCount > this.stackMax) {
            this.stackMax = this.stackCount;
        }
    }

    public void addLocalCount(int count) {
        this.localCount += count;
        if (this.localCount > this.localMax) {
            this.localMax = this.localCount;
        }
    }

    public void notifySourceLine(int line) {
        if (line > this.sourceLine) {
            this.sourceLine = line;
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(this.sourceLine, label);
        }
    }

    public void notifySourceEnd() {
        Label label = new Label();
        this.mv.visitLabel(label);
        this.mv.visitLineNumber(this.sourceLine + 1, label);
    }

    public void compileTypeConversion(Type fromType, Type toType) {
        if (fromType.equals(toType)) {
            return;
        }
        if (toType.isNumeric()) {
            this.compileNumericConversion(fromType, toType);
        } else if (toType.isString()) {
            this.compileStringConversion(fromType, toType);
        } else if (toType.isBoolean()) {
            this.compileBooleanConversion(fromType, toType);
        } else {
            this.compileObjectConversion(fromType, toType);
        }
    }

    public void compileNumericConversion(Type fromType, Type toType) {
        boolean unbox = fromType.isObject();
        boolean box = toType.isObject();
        if (unbox) {
            if (!fromType.isNumeric()) {
                if (toType == Type.C) {
                    this.compileObjectConversion(fromType, Type.CHARACTER);
                    fromType = Type.CHARACTER;
                } else {
                    this.compileObjectConversion(fromType, Type.NUMBER);
                    fromType = Type.NUMBER;
                }
            }
            if (box) {
                if (toType != Type.NUMBER) {
                    Type midType = Type.boxType(toType);
                    this.compileUnbox(fromType, midType);
                    this.compileBox(toType);
                }
            } else {
                this.compileUnbox(fromType, toType);
            }
        } else if (box) {
            if (toType == Type.CHARACTER) {
                this.compilePrimitiveConversion(fromType, Type.C);
                this.compileBox(toType);
            } else if (toType == Type.NUMBER) {
                toType = Type.boxType(fromType);
                this.compileBox(toType);
            } else {
                Type midType = Type.boxType(toType);
                if (fromType != midType) {
                    this.compilePrimitiveConversion(fromType, midType);
                }
                this.compileBox(toType);
            }
        } else {
            this.compilePrimitiveConversion(fromType, toType);
        }
    }

    public void compileUnbox(Type fromType, Type toType) {
        if (fromType == Type.BOOLEAN) {
            assert (toType == Type.Z);
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (fromType == Type.CHARACTER) {
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            this.compilePrimitiveConversion(Type.C, toType);
        } else if (toType == Type.B) {
            this.mv.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B");
        } else if (toType == Type.S) {
            this.mv.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S");
        } else if (toType == Type.C) {
            this.mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I");
            this.mv.visitIntInsn(120, 16);
            this.mv.visitIntInsn(123, 16);
        } else if (toType == Type.I) {
            this.mv.visitMethodInsn(182, "java/lang/Number", "intValue", "()I");
        } else if (toType == Type.J) {
            this.mv.visitMethodInsn(182, "java/lang/Number", "longValue", "()J");
            this.addStackCount(1);
        } else if (toType == Type.F) {
            this.mv.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F");
        } else {
            assert (toType == Type.D);
            this.addStackCount(1);
            this.mv.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D");
        }
    }

    public void compileBox(Type toType) {
        if (toType == Type.BOOLEAN) {
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (toType == Type.BYTE) {
            this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (toType == Type.SHORT) {
            this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (toType == Type.CHARACTER) {
            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (toType == Type.INTEGER) {
            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (toType == Type.LONG) {
            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            this.addStackCount(-1);
        } else if (toType == Type.FLOAT) {
            this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (toType == Type.DOUBLE) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            this.addStackCount(-1);
        }
    }

    public void compileStringConversion(Type fromType, Type toType) {
        assert (toType == Type.STRING);
        if (fromType.isObject() || fromType.isArray() || fromType.isNumeric() && !fromType.isPrimitive()) {
            Label elseLabel = new Label();
            Label endLabel = new Label();
            this.mv.visitInsn(89);
            this.addStackCount(1);
            this.mv.visitJumpInsn(199, elseLabel);
            this.addStackCount(-1);
            this.mv.visitInsn(87);
            this.mv.visitInsn(1);
            this.mv.visitJumpInsn(167, endLabel);
            this.mv.visitLabel(elseLabel);
            this.mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
            this.mv.visitLabel(endLabel);
        } else if (fromType == Type.Z) {
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "toString", "(Z)Ljava/lang/String;");
        } else if (fromType == Type.B) {
            this.mv.visitMethodInsn(184, "java/lang/Byte", "toString", "(B)Ljava/lang/String;");
        } else if (fromType == Type.S) {
            this.mv.visitMethodInsn(184, "java/lang/Short", "toString", "(S)Ljava/lang/String;");
        } else if (fromType == Type.C) {
            this.mv.visitMethodInsn(184, "java/lang/Character", "toString", "(C)Ljava/lang/String;");
        } else if (fromType == Type.I) {
            this.mv.visitMethodInsn(184, "java/lang/Integer", "toString", "(I)Ljava/lang/String;");
        } else if (fromType == Type.J) {
            this.mv.visitMethodInsn(184, "java/lang/Long", "toString", "(J)Ljava/lang/String;");
            this.addStackCount(-1);
        } else if (fromType == Type.F) {
            this.mv.visitMethodInsn(184, "java/lang/Float", "toString", "(F)Ljava/lang/String;");
        } else if (fromType == Type.D) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "toString", "(D)Ljava/lang/String;");
            this.addStackCount(-1);
        }
    }

    public void compilePrimitiveConversion(Type fromType, Type toType) {
        if (fromType == Type.B || fromType == Type.S || fromType == Type.I) {
            if (toType == Type.B) {
                this.mv.visitInsn(145);
            } else if (toType == Type.S) {
                this.mv.visitInsn(147);
            } else if (toType == Type.C) {
                this.mv.visitInsn(146);
            } else if (toType != Type.I) {
                if (toType == Type.J) {
                    this.mv.visitInsn(133);
                    this.addStackCount(1);
                } else if (toType == Type.F) {
                    this.mv.visitInsn(134);
                } else if (toType == Type.D) {
                    this.mv.visitInsn(135);
                    this.addStackCount(1);
                }
            }
        } else if (fromType == Type.C) {
            if (toType == Type.B) {
                this.mv.visitInsn(145);
            } else if (toType == Type.S) {
                this.mv.visitInsn(147);
            } else if (toType != Type.C && toType != Type.I) {
                if (toType == Type.J) {
                    this.mv.visitInsn(133);
                    this.addStackCount(1);
                } else if (toType == Type.F) {
                    this.mv.visitInsn(134);
                } else if (toType == Type.D) {
                    this.mv.visitInsn(135);
                    this.addStackCount(1);
                }
            }
        } else if (fromType == Type.J) {
            if (toType == Type.B || toType == Type.S || toType == Type.I || toType == Type.C) {
                this.mv.visitInsn(136);
                this.addStackCount(-1);
            } else if (toType != Type.J) {
                if (toType == Type.F) {
                    this.mv.visitInsn(137);
                    this.addStackCount(-1);
                } else if (toType == Type.D) {
                    this.mv.visitInsn(138);
                }
            }
        } else if (fromType == Type.F) {
            if (toType == Type.B) {
                this.mv.visitInsn(139);
                this.mv.visitInsn(145);
            } else if (toType == Type.S) {
                this.mv.visitInsn(139);
                this.mv.visitInsn(147);
            } else if (toType == Type.C) {
                this.mv.visitInsn(139);
                this.mv.visitInsn(146);
            } else if (toType == Type.I) {
                this.mv.visitInsn(139);
            } else if (toType == Type.J) {
                this.mv.visitInsn(140);
                this.addStackCount(1);
            } else if (toType != Type.F && toType == Type.D) {
                this.mv.visitInsn(141);
                this.addStackCount(1);
            }
        } else if (fromType == Type.D) {
            if (toType == Type.B) {
                this.mv.visitInsn(142);
                this.mv.visitInsn(145);
                this.addStackCount(-1);
            } else if (toType == Type.S) {
                this.mv.visitInsn(142);
                this.mv.visitInsn(147);
                this.addStackCount(-1);
            } else if (toType == Type.C) {
                this.mv.visitInsn(142);
                this.mv.visitInsn(146);
                this.addStackCount(-1);
            } else if (toType == Type.I) {
                this.mv.visitInsn(142);
                this.addStackCount(-1);
            } else if (toType == Type.J) {
                this.mv.visitInsn(143);
            } else if (toType == Type.F) {
                this.mv.visitInsn(144);
                this.addStackCount(-1);
            } else if (toType == Type.D) {
                // empty if block
            }
        }
    }

    public void compileBooleanConversion(Type fromType, Type toType) {
        if (toType == Type.Z) {
            if (fromType == Type.OBJECT) {
                fromType = Type.BOOLEAN;
                this.mv.visitTypeInsn(192, fromType.getInternalName());
            }
            assert (fromType == Type.BOOLEAN);
            this.compileUnbox(fromType, toType);
        } else {
            assert (toType == Type.BOOLEAN);
            if (fromType == Type.OBJECT) {
                this.mv.visitTypeInsn(192, toType.getInternalName());
            } else {
                assert (fromType == Type.Z);
                this.compileBox(toType);
            }
        }
    }

    public void compileObjectConversion(Type fromType, Type toType) {
        if (fromType.isPrimitive()) {
            Type boxType = Type.boxType(fromType);
            this.compileBox(boxType);
            fromType = boxType;
        }
        if (toType.isAssignableFrom(fromType)) {
            if (toType == Type.STRING && fromType != Type.STRING) {
                this.compileStringConversion(fromType, toType);
            }
        } else {
            assert (fromType.isAssignableFrom(toType));
            this.compileCheckCast(toType);
        }
    }

    public void compileCheckCast(Type toType) {
        this.mv.visitTypeInsn(192, toType.getInternalName());
    }
}

