/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.util.ArrayList;
import java.util.List;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.ArithmeticExpression;
import org.jboss.byteman.rule.expression.ArrayExpression;
import org.jboss.byteman.rule.expression.ArrayInitExpression;
import org.jboss.byteman.rule.expression.AssignExpression;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.BitExpression;
import org.jboss.byteman.rule.expression.BooleanLiteral;
import org.jboss.byteman.rule.expression.ClassLiteralExpression;
import org.jboss.byteman.rule.expression.ComparisonExpression;
import org.jboss.byteman.rule.expression.ConditionalEvalExpression;
import org.jboss.byteman.rule.expression.DollarExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.FieldExpression;
import org.jboss.byteman.rule.expression.InstanceOfExpression;
import org.jboss.byteman.rule.expression.LogicalExpression;
import org.jboss.byteman.rule.expression.MethodExpression;
import org.jboss.byteman.rule.expression.MinusExpression;
import org.jboss.byteman.rule.expression.NewExpression;
import org.jboss.byteman.rule.expression.NotExpression;
import org.jboss.byteman.rule.expression.NullLiteral;
import org.jboss.byteman.rule.expression.NumericLiteral;
import org.jboss.byteman.rule.expression.OperExpression;
import org.jboss.byteman.rule.expression.PlusExpression;
import org.jboss.byteman.rule.expression.ReturnExpression;
import org.jboss.byteman.rule.expression.ShiftExpression;
import org.jboss.byteman.rule.expression.StringLiteral;
import org.jboss.byteman.rule.expression.StringPlusExpression;
import org.jboss.byteman.rule.expression.ThrowExpression;
import org.jboss.byteman.rule.expression.TwiddleExpression;
import org.jboss.byteman.rule.expression.Variable;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.type.Type;

public class ExpressionHelper {
    public static Expression createExpression(Rule rule, Bindings bindings, ParseNode exprTree) throws TypeException {
        return ExpressionHelper.createExpression(rule, bindings, exprTree, Type.UNDEFINED);
    }

    public static Expression createExpression(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        Expression expr;
        int tag = exprTree.getTag();
        switch (tag) {
            case 9: {
                String name = (String)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                if (child1 == null && bindings.lookup(name) != null) {
                    expr = new Variable(rule, type, exprTree);
                    break;
                }
                throw new TypeException("ExpressionHelper.createExpression : unexpected IDENTIFIER " + exprTree.getText() + " in " + exprTree.getPos());
            }
            case 0: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                Expression arrayRef = ExpressionHelper.createExpression(rule, bindings, child0, Type.UNDEFINED);
                List<Expression> indices = ExpressionHelper.createExpressionList(rule, bindings, child1, Type.I);
                if (indices != null) {
                    expr = new ArrayExpression(rule, type, exprTree, arrayRef, indices);
                    break;
                }
                throw new TypeException("ExpressionHelper.createExpression : invalid array index expression " + exprTree.getPos());
            }
            case 7: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                expr = ExpressionHelper.createFieldExpression(rule, bindings, child0, child1, type);
                break;
            }
            case 22: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                expr = ExpressionHelper.createClassLiteralExpression(rule, bindings, child0, type);
                break;
            }
            case 11: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                ParseNode child2 = (ParseNode)exprTree.getChild(2);
                int tag0 = child0.getTag();
                if (tag0 != 9) {
                    throw new TypeException("ExpressionHelper.createExpression : invalid method selector " + tag + " in expression " + child0.getText() + child0.getPos());
                }
                expr = ExpressionHelper.createCallExpression(rule, bindings, child0, child1, child2, type);
                break;
            }
            case 18: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                int tag0 = child0.getTag();
                if (tag0 != 9) {
                    throw new TypeException("ExpressionHelper.createExpression : invalid throw type " + tag + " in expression " + child0.getText() + child0.getPos());
                }
                expr = ExpressionHelper.createThrowExpression(rule, bindings, child0, child1);
                break;
            }
            case 20: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                ParseNode child2 = (ParseNode)exprTree.getChild(2);
                int tag0 = child0.getTag();
                if (tag0 != 9) {
                    throw new TypeException("ExpressionHelper.createExpression : invalid new type " + tag + " in expression " + child0.getText() + child0.getPos());
                }
                expr = ExpressionHelper.createNewExpression(rule, bindings, child0, child1, child2);
                break;
            }
            case 8: 
            case 10: {
                Object value = exprTree.getChild(0);
                Type t = Type.boxType(value.getClass());
                expr = new NumericLiteral(rule, t, exprTree);
                break;
            }
            case 16: {
                expr = new StringLiteral(rule, exprTree);
                break;
            }
            case 4: {
                expr = new BooleanLiteral(rule, exprTree);
                break;
            }
            case 21: {
                expr = new NullLiteral(rule, exprTree);
                break;
            }
            case 14: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                Expression returnValue = child0 != null ? ExpressionHelper.createExpression(rule, bindings, child0) : null;
                expr = new ReturnExpression(rule, exprTree, returnValue);
                break;
            }
            case 35: {
                String text = (String)exprTree.getChild(0);
                char leading = text.charAt(1);
                if (Character.isDigit(leading)) {
                    int index = Integer.valueOf(text.substring(1));
                    expr = new DollarExpression(rule, type, exprTree, index);
                    break;
                }
                if (text.equals("$!")) {
                    expr = new DollarExpression(rule, type, exprTree, -4);
                    break;
                }
                if (text.equals("$^")) {
                    expr = new DollarExpression(rule, type, exprTree, -5);
                    break;
                }
                if (text.equals("$#")) {
                    expr = new DollarExpression(rule, Type.I, exprTree, -6);
                    break;
                }
                if (text.equals("$*")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -7);
                    break;
                }
                if (text.equals("$@")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -8);
                    break;
                }
                if (text.equals("$CLASS")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -9);
                    break;
                }
                if (text.equals("$METHOD")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -10);
                    break;
                }
                if (text.equals("$NEWCLASS")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -11);
                    break;
                }
                expr = new DollarExpression(rule, type, exprTree, text.substring(1));
                break;
            }
            case 1: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                AssignableExpression left = ExpressionHelper.createAssignableExpression(rule, bindings, child0, type);
                Expression right = ExpressionHelper.createExpression(rule, bindings, child1, type);
                expr = new AssignExpression(rule, exprTree, left, right);
                break;
            }
            case 19: {
                expr = ExpressionHelper.createUnaryExpression(rule, bindings, exprTree, type);
                break;
            }
            case 3: {
                expr = ExpressionHelper.createBinaryExpression(rule, bindings, exprTree, type);
                break;
            }
            case 17: {
                expr = ExpressionHelper.createTernaryExpression(rule, bindings, exprTree, type);
                break;
            }
            case 23: {
                expr = ExpressionHelper.createArrayInitExpression(rule, bindings, exprTree, type);
                break;
            }
            default: {
                throw new TypeException("ExpressionHelper.createExpression : unexpected token type " + tag + " for expression " + exprTree.getPos());
            }
        }
        Type exprType = Type.dereference(expr.getType());
        Type targetType = Type.dereference(type);
        if (exprType.isDefined() && targetType.isDefined() && !targetType.isAssignableFrom(exprType)) {
            throw new TypeException("ExpressionHelper.createExpression : invalid expression type " + exprType.getName() + " expecting " + targetType.getName() + exprTree.getPos());
        }
        if (targetType.isNumeric() && !exprType.isNumeric()) {
            throw new TypeException("ExpressionHelper.createExpression : invalid expression type " + exprType.getName() + " expecting " + targetType.getName() + exprTree.getPos());
        }
        return expr;
    }

    public static AssignableExpression createFieldExpression(Rule rule, Bindings bindings, ParseNode fieldTree, ParseNode targetTree, Type type) throws TypeException {
        String[] pathList;
        Expression target;
        if (targetTree.getTag() == 13) {
            target = null;
            pathList = ExpressionHelper.createPathList(targetTree);
        } else {
            target = ExpressionHelper.createExpression(rule, bindings, targetTree, Type.UNDEFINED);
            pathList = null;
        }
        FieldExpression fieldExpr = new FieldExpression(rule, type, fieldTree, fieldTree.getText(), target, pathList);
        return fieldExpr;
    }

    public static ClassLiteralExpression createClassLiteralExpression(Rule rule, Bindings bindings, ParseNode pathTree, Type type) throws TypeException {
        String[] pathList = ExpressionHelper.createPathList(pathTree);
        ClassLiteralExpression classLiteralExpr = new ClassLiteralExpression(rule, type, pathTree, pathList);
        return classLiteralExpr;
    }

    public static Expression createCallExpression(Rule rule, Bindings bindings, ParseNode selectorTree, ParseNode recipientTree, ParseNode argTree, Type type) throws TypeException {
        String[] pathList;
        Expression recipient;
        if (recipientTree == null) {
            recipient = null;
            pathList = null;
        } else if (recipientTree.getTag() == 13) {
            recipient = null;
            pathList = ExpressionHelper.createPathList(recipientTree);
        } else {
            recipient = ExpressionHelper.createExpression(rule, bindings, recipientTree, Type.UNDEFINED);
            pathList = null;
        }
        List<Object> args = argTree == null ? new ArrayList() : ExpressionHelper.createExpressionList(rule, bindings, argTree);
        MethodExpression expr = new MethodExpression(rule, type, selectorTree, recipient, args, pathList);
        return expr;
    }

    public static String[] createPathList(ParseNode pathTree) {
        ParseNode p;
        int l = 0;
        for (p = pathTree; p != null; p = (ParseNode)p.getChild(1)) {
            ++l;
        }
        String[] pathList = new String[l];
        for (p = pathTree; p != null; p = (ParseNode)p.getChild(1)) {
            pathList[--l] = p.getText();
        }
        return pathList;
    }

    public static Expression createThrowExpression(Rule rule, Bindings bindings, ParseNode typeNameTree, ParseNode argTree) throws TypeException {
        List<Object> args = argTree == null ? new ArrayList() : ExpressionHelper.createExpressionList(rule, bindings, argTree);
        ThrowExpression expr = new ThrowExpression(rule, typeNameTree, args);
        return expr;
    }

    public static Expression createNewExpression(Rule rule, Bindings bindings, ParseNode typeNameTree, ParseNode argTree, ParseNode arrayDimsTree) throws TypeException {
        ArrayInitExpression arrayInits;
        List<Object> arrayDims;
        List<Object> args = argTree == null ? new ArrayList() : ExpressionHelper.createExpressionList(rule, bindings, argTree);
        if (arrayDimsTree == null) {
            arrayDims = new ArrayList();
            arrayInits = null;
        } else if (arrayDimsTree.getTag() == 23) {
            ParseNode child0 = (ParseNode)arrayDimsTree.getChild(0);
            ParseNode child1 = (ParseNode)arrayDimsTree.getChild(1);
            arrayDims = ExpressionHelper.createNewArrayDimsList(rule, bindings, child0);
            arrayInits = ExpressionHelper.createArrayInitExpression(rule, bindings, child1, Type.UNDEFINED);
        } else {
            arrayDims = ExpressionHelper.createNewArrayDimsList(rule, bindings, arrayDimsTree);
            arrayInits = null;
        }
        NewExpression expr = new NewExpression(rule, typeNameTree, args, arrayDims, arrayInits);
        return expr;
    }

    public static Expression createUnaryExpression(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        Expression expr;
        ParseNode child0 = (ParseNode)exprTree.getChild(0);
        ParseNode child1 = (ParseNode)exprTree.getChild(1);
        int tag = child0.getTag();
        switch (tag) {
            case 48: {
                if (!(type.isUndefined() || type.isVoid() || type.isNumeric())) {
                    throw new TypeException("ExpressionHelper.createUnaryExpression : invalid numeric expression" + exprTree.getPos());
                }
                Expression operand = ExpressionHelper.createExpression(rule, bindings, child1, Type.NUMBER);
                expr = new TwiddleExpression(rule, exprTree, operand);
                break;
            }
            case 45: {
                if (!(type.isUndefined() || type.isVoid() || type.isBoolean())) {
                    throw new TypeException("ExpressionHelper.createUnaryExpression : invalid boolean expression" + exprTree.getPos());
                }
                Expression operand = ExpressionHelper.createExpression(rule, bindings, child1, Type.BOOLEAN);
                expr = new NotExpression(rule, exprTree, operand);
                break;
            }
            case 49: {
                if (!(type.isUndefined() || type.isVoid() || type.isBoolean())) {
                    throw new TypeException("ExpressionHelper.createUnaryExpression : invalid boolean expression" + exprTree.getPos());
                }
                Expression operand = ExpressionHelper.createExpression(rule, bindings, child1, Type.NUMBER);
                expr = new MinusExpression(rule, exprTree, operand);
                break;
            }
            case 35: {
                if (child1.getTag() == 9) {
                    if (child1.getText().equals("!")) {
                        expr = new DollarExpression(rule, type, exprTree, -4);
                        break;
                    }
                    if (child1.getText().equals("^")) {
                        expr = new DollarExpression(rule, type, exprTree, -5);
                        break;
                    }
                    if (child1.getText().equals("#")) {
                        expr = new DollarExpression(rule, Type.I, exprTree, -6);
                        break;
                    }
                    if (child1.getText().equals("*")) {
                        expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -7);
                        break;
                    }
                    if (child1.getText().equals("@")) {
                        expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -8);
                        break;
                    }
                    if (child1.getText().equals("CLASS")) {
                        expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -9);
                        break;
                    }
                    if (child1.getText().equals("METHOD")) {
                        expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -10);
                        break;
                    }
                    expr = new DollarExpression(rule, type, exprTree, child1.getText());
                    break;
                }
                if (child1.getTag() == 10) {
                    Integer intObject = (Integer)child1.getChild(0);
                    expr = new DollarExpression(rule, type, exprTree, intObject);
                    break;
                }
                throw new TypeException("ExpressionHelper.createUnaryExpression : unexpected token type " + child1.getTag() + " for dollar expression tree " + child1.getText() + "" + child1.getPos());
            }
            default: {
                throw new TypeException("ExpressionHelper.createUnaryExpression : unexpected token type " + exprTree.getTag() + " for expression tree " + exprTree.getText() + "" + exprTree.getPos());
            }
        }
        return expr;
    }

    public static Expression createBinaryExpression(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        BinaryOperExpression expr;
        ParseNode child0 = (ParseNode)exprTree.getChild(0);
        ParseNode child1 = (ParseNode)exprTree.getChild(1);
        ParseNode child2 = (ParseNode)exprTree.getChild(2);
        int oper = child0.getTag();
        switch (oper) {
            case 47: {
                if (type.isNumeric()) {
                    Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.NUMBER);
                    Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.NUMBER);
                    int convertedOper = OperExpression.convertOper(oper);
                    expr = new ArithmeticExpression(rule, convertedOper, exprTree, operand1, operand2);
                    break;
                }
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.UNDEFINED);
                if (operand1.getType().isNumeric()) {
                    Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.NUMBER);
                    int convertedOper = OperExpression.convertOper(oper);
                    expr = new ArithmeticExpression(rule, convertedOper, exprTree, operand1, operand2);
                    break;
                }
                if (operand1.getType() == Type.STRING) {
                    Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.UNDEFINED);
                    expr = new StringPlusExpression(rule, exprTree, operand1, operand2);
                    break;
                }
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.UNDEFINED);
                expr = new PlusExpression(rule, exprTree, operand1, operand2);
                break;
            }
            case 34: 
            case 41: 
            case 42: 
            case 43: {
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.NUMBER);
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.NUMBER);
                int convertedOper = OperExpression.convertOper(oper);
                expr = new ArithmeticExpression(rule, convertedOper, exprTree, operand1, operand2);
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.NUMBER);
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.NUMBER);
                int convertedOper = OperExpression.convertOper(oper);
                expr = new ShiftExpression(rule, convertedOper, exprTree, operand1, operand2);
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.NUMBER);
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.NUMBER);
                int convertedOper = OperExpression.convertOper(oper);
                expr = new BitExpression(rule, convertedOper, exprTree, operand1, operand2);
                break;
            }
            case 30: 
            case 46: {
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.BOOLEAN);
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.BOOLEAN);
                int convertedOper = OperExpression.convertOper(oper);
                expr = new LogicalExpression(rule, convertedOper, exprTree, operand1, operand2);
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: {
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.UNDEFINED);
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, Type.UNDEFINED);
                int convertedOper = OperExpression.convertOper(oper);
                expr = new ComparisonExpression(rule, convertedOper, exprTree, operand1, operand2);
                break;
            }
            case 53: {
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, Type.UNDEFINED);
                ClassLiteralExpression operand2 = ExpressionHelper.createClassLiteralExpression(rule, bindings, child2, Type.UNDEFINED);
                int convertedOper = OperExpression.convertOper(oper);
                expr = new InstanceOfExpression(rule, convertedOper, exprTree, operand1, operand2);
                break;
            }
            default: {
                throw new TypeException("ExpressionHelper.createBinaryExpression : unexpected token type " + exprTree.getTag() + " for expression " + exprTree.getText() + "" + exprTree.getPos());
            }
        }
        return expr;
    }

    public static Expression createTernaryExpression(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        ConditionalEvalExpression expr;
        ParseNode child0 = (ParseNode)exprTree.getChild(0);
        ParseNode child1 = (ParseNode)exprTree.getChild(1);
        ParseNode child2 = (ParseNode)exprTree.getChild(2);
        int oper = exprTree.getTag();
        switch (oper) {
            case 17: {
                Expression operand0 = ExpressionHelper.createExpression(rule, bindings, child0, Type.BOOLEAN);
                Expression operand1 = ExpressionHelper.createExpression(rule, bindings, child1, type);
                Expression operand2 = ExpressionHelper.createExpression(rule, bindings, child2, type);
                Type type1 = Type.dereference(operand1.getType());
                Type type2 = Type.dereference(operand2.getType());
                if (type1.isNumeric() || type2.isNumeric()) {
                    if (!(type.isUndefined() || type.isVoid() || type.isNumeric())) {
                        throw new TypeException("ExpressionHelper.createUnaryExpression : invalid numeric expression" + exprTree.getPos());
                    }
                    expr = new ConditionalEvalExpression(rule, Type.promote(type1, type2), exprTree, operand0, operand1, operand2);
                    break;
                }
                if (type1.isDefined() && type2.isDefined()) {
                    if (type1 == type2) {
                        expr = new ConditionalEvalExpression(rule, type1, exprTree, operand0, operand1, operand2);
                        break;
                    }
                    throw new TypeException("ExpressionHelper.createTernaryExpression : mismatched expression types " + type1.getName() + " and " + type2.getName() + " in conditional expression " + exprTree.getText() + exprTree.getPos());
                }
                expr = new ConditionalEvalExpression(rule, Type.UNDEFINED, exprTree, operand0, operand1, operand2);
                break;
            }
            default: {
                throw new TypeException("ExpressionHelper.createTernaryExpression : unexpected token type " + exprTree.getTag() + " for expression " + exprTree.getText() + "" + exprTree.getPos());
            }
        }
        return expr;
    }

    public static ArrayInitExpression createArrayInitExpression(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        List<Expression> expr_list;
        if (exprTree.getChildCount() == 1) {
            Type baseType = type.isArray() ? type.getBaseType() : Type.UNDEFINED;
            ParseNode child0 = (ParseNode)exprTree.getChild(0);
            expr_list = ExpressionHelper.createExpressionList(rule, bindings, child0, baseType);
        } else {
            expr_list = new ArrayList<Expression>();
        }
        ArrayInitExpression expr = new ArrayInitExpression(rule, type, exprTree, expr_list);
        return expr;
    }

    public static AssignableExpression createAssignableExpression(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        AssignableExpression expr;
        int tag = exprTree.getTag();
        switch (tag) {
            case 7: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                expr = ExpressionHelper.createFieldExpression(rule, bindings, child0, child1, type);
                break;
            }
            case 9: {
                String name = (String)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                if (child1 == null && bindings.lookup(name) != null) {
                    expr = new Variable(rule, type, exprTree, name);
                    break;
                }
                throw new TypeException("ExpressionHelper.createAssignableExpression : unexpected IDENTIFIER " + exprTree.getText() + " in " + exprTree.getPos());
            }
            case 35: {
                String text = (String)exprTree.getChild(0);
                char leading = text.charAt(1);
                if (Character.isDigit(leading)) {
                    int index = Integer.valueOf(text.substring(1));
                    expr = new DollarExpression(rule, type, exprTree, index);
                    break;
                }
                if (text.equals("$!")) {
                    expr = new DollarExpression(rule, type, exprTree, -4);
                    break;
                }
                if (text.equals("$^")) {
                    expr = new DollarExpression(rule, type, exprTree, -5);
                    break;
                }
                if (text.equals("$#")) {
                    expr = new DollarExpression(rule, Type.I, exprTree, -6);
                    break;
                }
                if (text.equals("$*")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -7);
                    break;
                }
                if (text.equals("$@")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -8);
                    break;
                }
                if (text.equals("$CLASS")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -9);
                    break;
                }
                if (text.equals("$METHOD")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -10);
                    break;
                }
                if (text.equals("$NEWCLASS")) {
                    expr = new DollarExpression(rule, rule.getTypeGroup().createArray(Type.OBJECT), exprTree, -11);
                    break;
                }
                expr = new DollarExpression(rule, type, exprTree, text.substring(1));
                break;
            }
            case 0: {
                ParseNode child0 = (ParseNode)exprTree.getChild(0);
                ParseNode child1 = (ParseNode)exprTree.getChild(1);
                Expression arrayRef = ExpressionHelper.createExpression(rule, bindings, child0, Type.UNDEFINED);
                List<Expression> indices = ExpressionHelper.createExpressionList(rule, bindings, child1, Type.I);
                if (indices != null) {
                    expr = new ArrayExpression(rule, type, exprTree, arrayRef, indices);
                    break;
                }
                throw new TypeException("ExpressionHelper.createExpression : invalid array index expression " + exprTree.getPos());
            }
            default: {
                throw new TypeException("ExpressionHelper.createAssignableExpression : unexpected token type " + tag + " for lhs of assignment " + exprTree.getPos());
            }
        }
        return expr;
    }

    public static List<Expression> createExpressionList(Rule rule, Bindings bindings, ParseNode exprTree) throws TypeException {
        return ExpressionHelper.createExpressionList(rule, bindings, exprTree, Type.UNDEFINED);
    }

    public static List<Expression> createExpressionList(Rule rule, Bindings bindings, ParseNode exprTree, Type type) throws TypeException {
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        ArrayList<TypeException> exceptions = new ArrayList<TypeException>();
        block5: while (exprTree != null) {
            try {
                Expression expr;
                switch (exprTree.getTag()) {
                    case 5: 
                    case 15: {
                        ParseNode child0 = (ParseNode)exprTree.getChild(0);
                        exprTree = (ParseNode)exprTree.getChild(1);
                        expr = ExpressionHelper.createExpression(rule, bindings, child0, type);
                        exprList.add(expr);
                        continue block5;
                    }
                }
                ParseNode saveTree = exprTree;
                exprTree = null;
                expr = ExpressionHelper.createExpression(rule, bindings, saveTree, type);
                exprList.add(expr);
            }
            catch (TypeException te) {
                exceptions.add(te);
            }
        }
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (TypeException)exceptions.get(0);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("ExpressionHelper.createExpressionList : errors checking expression sequence");
            for (TypeException typeException : exceptions) {
                buffer.append("\n");
                buffer.append(typeException.toString());
            }
            throw new TypeException(buffer.toString());
        }
        return exprList;
    }

    public static List<Expression> createNewArrayDimsList(Rule rule, Bindings bindings, ParseNode exprTree) throws TypeException {
        Type type = Type.I;
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        ArrayList<TypeException> exceptions = new ArrayList<TypeException>();
        boolean foundEmptyDim = false;
        int arrayDimCount = 0;
        int emptyDimCount = 0;
        while (exprTree != null) {
            try {
                ParseNode child;
                ParseNode saveTree = exprTree;
                if (exprTree.getTag() == 5) {
                    child = (ParseNode)exprTree.getChild(0);
                    exprTree = (ParseNode)exprTree.getChild(1);
                } else {
                    child = exprTree;
                    exprTree = null;
                }
                ++arrayDimCount;
                if (child.getTag() == 12) {
                    ++emptyDimCount;
                    foundEmptyDim = true;
                    exprList.add(null);
                    continue;
                }
                if (!foundEmptyDim) {
                    Expression expr = ExpressionHelper.createExpression(rule, bindings, child, Type.I);
                    exprList.add(expr);
                    continue;
                }
                throw new TypeException("ExpressionHelper.createNewArrayDimsList : invalid array dimension " + child.getPos());
            }
            catch (TypeException te) {
                exceptions.add(te);
            }
        }
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (TypeException)exceptions.get(0);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("ExpressionHelper.createNewArrayDimsList : errors checking new expression array dimensions");
            for (TypeException typeException : exceptions) {
                buffer.append("\n");
                buffer.append(typeException.toString());
            }
            throw new TypeException(buffer.toString());
        }
        return exprList;
    }
}

