/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class Variable
extends AssignableExpression {
    private String name;
    private Binding binding;

    public Variable(Rule rule, Type type, ParseNode token) {
        super(rule, type, token);
        this.name = token.getText();
        this.binding = null;
    }

    public Variable(Rule rule, Type type, ParseNode token, String name) {
        super(rule, type, token);
        this.name = name;
        this.binding = null;
    }

    @Override
    public void bind() throws TypeException {
        this.bind(false);
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind(true);
    }

    private boolean bind(boolean isUpdateable) throws TypeException {
        this.binding = this.getBindings().lookup(this.name);
        if (this.binding == null) {
            throw new TypeException("Variable.bind : unbound variable " + this.name + this.getPos());
        }
        if (isUpdateable) {
            this.binding.setUpdated();
        }
        this.type = this.binding.getType();
        return true;
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("Variable.typeCheck() : invalid result type : " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Type typeCheckAssign(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !this.type.isAssignableFrom(expected)) {
            throw new TypeException("Variable.typeCheck() : invalid value type : " + expected.getName() + " for assignment " + this.getPos());
        }
        return this.type;
    }

    public void typeCheckAny() throws TypeException {
        Binding binding = this.getBindings().lookup(this.name);
        this.type = Type.dereference(binding.getType());
        if (this.type.isUndefined()) {
            throw new TypeException("Variable.typeCheck : unable to derive type for variable " + this.name + this.getPos());
        }
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return helper.getBinding(this.name);
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        String ivarName = this.binding.getIVarName();
        Type type = this.type;
        if (this.rule.requiresAccess(type)) {
            type = Type.OBJECT;
        }
        int expected = type.getNBytes() > 4 ? 2 : 1;
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.rule.getHelperImplementationClassName(), ivarName, type.getInternalName(true, true));
        compileContext.addStackCount(expected);
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        helperAdapter.setBinding(this.name, value);
        return value;
    }

    @Override
    public void compileAssign(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        String ivarName = this.binding.getIVarName();
        Type type = this.type;
        if (this.rule.requiresAccess(type)) {
            type = Type.OBJECT;
        }
        int size = type.getNBytes() > 4 ? 2 : 1;
        int currentStack = compileContext.getStackCount();
        if (size == 2) {
            mv.visitInsn(92);
        } else {
            mv.visitInsn(89);
        }
        compileContext.addStackCount(size);
        mv.visitVarInsn(25, 0);
        compileContext.addStackCount(1);
        if (size == 2) {
            mv.visitInsn(91);
            compileContext.addStackCount(1);
            mv.visitInsn(87);
            compileContext.addStackCount(-1);
        } else {
            mv.visitInsn(95);
        }
        mv.visitFieldInsn(181, this.rule.getHelperImplementationClassName(), ivarName, type.getInternalName(true, true));
        compileContext.addStackCount(-1 - size);
        if (compileContext.getStackCount() != currentStack) {
            throw new CompileException("variable.compileAssignment : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write(this.name);
    }
}

