/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.TimestampCopyingBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class TimestampBinder
extends DateCommonBinder {
    Binder theTimestampCopyingBinder = null;
    Timestamp paramVal;

    static void init(Binder binder, int n2) {
        binder.type = (short)180;
        binder.bytelen = 11;
        binder.scale = (short)n2;
    }

    TimestampBinder(Timestamp timestamp) {
        TimestampBinder.init(this, -1);
        this.paramVal = timestamp;
    }

    TimestampBinder(Timestamp timestamp, int n2) {
        TimestampBinder.init(this, n2);
        this.paramVal = timestamp;
    }

    @Override
    Binder copyingBinder() {
        if (this.theTimestampCopyingBinder == null) {
            this.theTimestampCopyingBinder = new TimestampCopyingBinder();
        }
        return this.theTimestampCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement oraclePreparedStatement, int n2, int n3, int n4, byte[] byArray, char[] cArray, short[] sArray, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, long l2, ByteArray byteArray, long[] lArray, int[] nArray, int n11, boolean bl2, int n12) throws SQLException {
        Timestamp timestamp = this.paramVal;
        byte[] byArray2 = null;
        int n13 = 0;
        int n14 = 0;
        long l3 = 0L;
        if (bl) {
            this.paramVal = null;
        }
        if (timestamp == null) {
            sArray[n10] = -1;
            if (bl2) {
                lArray[n11] = -1L;
                nArray[n11] = 0;
            }
        } else {
            if (bl2) {
                lArray[n11] = l3 = byteArray.getPosition();
                oraclePreparedStatement.lastBoundDataOffsets[n2] = l3;
                byArray2 = oraclePreparedStatement.connection.methodTempLittleByteBuffer;
                n7 = 0;
                n13 = 0;
            } else {
                byArray2 = byArray;
                n13 = n7;
            }
            sArray[n10] = 0;
            n14 = this.getDatumBytes(oraclePreparedStatement, timestamp, byArray2, n13, bl2, n5);
        }
        if (bl2) {
            byteArray.put(byArray2, 0, n14);
            sArray[n10] = 0;
            nArray[n11] = n14;
            oraclePreparedStatement.lastBoundDataLengths[n2] = n14;
            sArray[n9] = (short)n14;
        } else {
            sArray[n10] = 0;
            sArray[n9] = (short)n14;
        }
        if (oraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
            l2 = sArray[n10] == -1 ? CRC64.updateChecksum(l2, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(l2, timestamp.getTime());
        }
        return l2;
    }

    private int getDatumBytes(OraclePreparedStatement oraclePreparedStatement, Timestamp timestamp, byte[] byArray, int n2, boolean bl, int n3) throws SQLException {
        int n4 = 0;
        TimestampBinder.setOracleHMS(TimestampBinder.setOracleCYMD(timestamp.getTime(), byArray, n2, oraclePreparedStatement), byArray, n2);
        int n5 = timestamp.getNanos();
        if (n5 != 0) {
            TimestampBinder.setOracleNanos(n5, byArray, n2);
            n4 = bl ? 11 : n3;
        } else {
            n4 = 7;
        }
        return n4;
    }

    @Override
    Datum getDatum(OraclePreparedStatement oraclePreparedStatement, int n2, int n3, int n4) throws SQLException {
        byte[] byArray = oraclePreparedStatement.connection.methodTempLittleByteBuffer;
        int n5 = this.getDatumBytes(oraclePreparedStatement, this.paramVal, byArray, 0, true, 0);
        return SQLUtil.makeDatum((OracleConnection)oraclePreparedStatement.connection, Arrays.copyOf(byArray, n5), n4, null, 0);
    }
}

