/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config.database;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Database {
    private static final Map<String, Vendor> DATABASES = new HashMap<String, Vendor>();

    public static boolean isLiquibaseDatabaseSupported(String databaseType, String dbKind) {
        for (Vendor vendor : DATABASES.values()) {
            if (!vendor.liquibaseTypes.contains(databaseType) || !vendor.isOfKind(dbKind)) continue;
            return true;
        }
        return false;
    }

    public static Optional<String> getDatabaseKind(String alias) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        return Optional.of(vendor.databaseKind);
    }

    public static Optional<String> getDefaultUrl(String alias) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        return Optional.of(vendor.defaultUrl.apply(alias));
    }

    public static Optional<String> getDriver(String alias, boolean isXaEnabled) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        if (isXaEnabled) {
            return Optional.of(vendor.xaDriver);
        }
        return Optional.of(vendor.nonXaDriver);
    }

    public static Optional<String> getDialect(String alias) {
        Vendor vendor = DATABASES.get(alias);
        if (vendor == null) {
            return Optional.empty();
        }
        return Optional.of(vendor.dialect.apply(alias));
    }

    public static List<String> getAliases() {
        return DATABASES.keySet().stream().sorted().collect(Collectors.toList());
    }

    static {
        for (Vendor vendor : Vendor.values()) {
            for (String alias : vendor.aliases) {
                DATABASES.put(alias, vendor);
            }
        }
    }

    public static enum Vendor {
        H2("h2", "org.h2.jdbcx.JdbcDataSource", "org.h2.Driver", "io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect", new Function<String, String>(){

            @Override
            public String apply(String alias) {
                if ("dev-file".equalsIgnoreCase(alias)) {
                    return this.addH2NonKeywords("jdbc:h2:file:${kc.home.dir:${kc.db-url-path:" + System.getProperty("user.home") + "}}" + File.separator + "${kc.data.dir:data}" + File.separator + "h2" + File.separator + "keycloakdb${kc.db-url-properties:;;AUTO_SERVER=TRUE}");
                }
                return this.addH2NonKeywords("jdbc:h2:mem:keycloakdb${kc.db-url-properties:}");
            }

            private String addH2NonKeywords(String jdbcUrl) {
                if (!((String)jdbcUrl).contains("NON_KEYWORDS=")) {
                    jdbcUrl = (String)jdbcUrl + ";NON_KEYWORDS=VALUE";
                }
                return jdbcUrl;
            }
        }, Arrays.asList("liquibase.database.core.H2Database"), "dev-mem", "dev-file"),
        MYSQL("mysql", "com.mysql.cj.jdbc.MysqlXADataSource", "com.mysql.cj.jdbc.Driver", "org.hibernate.dialect.MySQL8Dialect", "jdbc:mysql://${kc.db-url-host:localhost}:${kc.db-url-port:3306}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("org.keycloak.connections.jpa.updater.liquibase.UpdatedMySqlDatabase"), new String[0]),
        MARIADB("mariadb", "org.mariadb.jdbc.MariaDbDataSource", "org.mariadb.jdbc.Driver", "org.hibernate.dialect.MariaDBDialect", "jdbc:mariadb://${kc.db-url-host:localhost}:${kc.db-url-port:3306}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("org.keycloak.connections.jpa.updater.liquibase.UpdatedMariaDBDatabase"), new String[0]),
        POSTGRES("postgresql", "org.postgresql.xa.PGXADataSource", "org.postgresql.Driver", "io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL10Dialect", "jdbc:postgresql://${kc.db-url-host:localhost}:${kc.db-url-port:5432}/${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("liquibase.database.core.PostgresDatabase", "liquibase.database.core.CockroachDatabase", "org.keycloak.connections.jpa.updater.liquibase.PostgresPlusDatabase"), "postgres"),
        MSSQL("mssql", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.hibernate.dialect.SQLServer2016Dialect", "jdbc:sqlserver://${kc.db-url-host:localhost}:${kc.db-url-port:1433};databaseName=${kc.db-url-database:keycloak}${kc.db-url-properties:}", Arrays.asList("org.keycloak.quarkus.runtime.storage.database.liquibase.database.CustomMSSQLDatabase"), "mssql"),
        ORACLE("oracle", "oracle.jdbc.xa.client.OracleXADataSource", "oracle.jdbc.driver.OracleDriver", "org.hibernate.dialect.Oracle12cDialect", "jdbc:oracle:thin:@//${kc.db-url-host:localhost}:${kc.db-url-port:1521}/${kc.db-url-database:keycloak}", Arrays.asList("liquibase.database.core.OracleDatabase"), new String[0]);

        final String databaseKind;
        final String xaDriver;
        final String nonXaDriver;
        final Function<String, String> dialect;
        final Function<String, String> defaultUrl;
        final List<String> liquibaseTypes;
        final String[] aliases;

        private Vendor(String databaseKind, String xaDriver, String nonXaDriver, String dialect, String defaultUrl, List<String> liquibaseTypes, String ... aliases) {
            this(databaseKind, xaDriver, nonXaDriver, (String alias) -> dialect, (String alias) -> defaultUrl, liquibaseTypes, aliases);
        }

        private Vendor(String databaseKind, String xaDriver, String nonXaDriver, String dialect, Function<String, String> defaultUrl, List<String> liquibaseTypes, String ... aliases) {
            this(databaseKind, xaDriver, nonXaDriver, (String alias) -> dialect, defaultUrl, liquibaseTypes, aliases);
        }

        private Vendor(String databaseKind, String xaDriver, String nonXaDriver, Function<String, String> dialect, Function<String, String> defaultUrl, List<String> liquibaseTypes, String ... aliases) {
            String[] stringArray;
            this.databaseKind = databaseKind;
            this.xaDriver = xaDriver;
            this.nonXaDriver = nonXaDriver;
            this.dialect = dialect;
            this.defaultUrl = defaultUrl;
            this.liquibaseTypes = liquibaseTypes;
            if (aliases.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = databaseKind;
            } else {
                stringArray = aliases;
            }
            this.aliases = stringArray;
        }

        public boolean isOfKind(String dbKind) {
            return this.databaseKind.equals(dbKind);
        }

        public String toString() {
            return this.databaseKind.toLowerCase(Locale.ROOT);
        }
    }
}

