/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.INamespace;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Namespace
extends KubernetesResource
implements INamespace {
    private static final String ANNOTATION_DISPLAY_NAME = "openshift.io/display-name";
    private static final String ANNOTATION_DESCRIPTION = "openshift.io/description";
    private static final String ANNOTATION_REQUESTER = "openshift.io/requester";

    public Namespace(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, this.getClient());
    }

    @Override
    public <T extends IResource> List<T> getResources(String kind) {
        if (this.getClient() == null) {
            return new ArrayList();
        }
        return this.getClient().list(kind, this.getName());
    }

    @Override
    public Namespace getNamespace() {
        return this;
    }

    @Override
    public String getNamespaceName() {
        return this.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getAnnotation(ANNOTATION_DISPLAY_NAME);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.setAnnotation(ANNOTATION_DISPLAY_NAME, displayName);
    }

    @Override
    public String getDescription() {
        return this.getAnnotation(ANNOTATION_DESCRIPTION);
    }

    @Override
    public void setDescription(String description) {
        this.setAnnotation(ANNOTATION_DESCRIPTION, description);
    }

    @Override
    public String getRequester() {
        return this.getAnnotation(ANNOTATION_REQUESTER);
    }

    @Override
    public void setRequest(String requester) {
        this.setAnnotation(ANNOTATION_REQUESTER, requester);
    }
}

