/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.serviceaccount.IServiceAccount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServiceAccount
extends KubernetesResource
implements IServiceAccount {
    private static final String SERVICE_ACCOUNT_SECRETS = "secrets";
    private static final String SERVICE_ACCOUNT_IMAGE_PULL_SECRETS = "imagePullSecrets";

    public ServiceAccount(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public Collection<String> getSecrets() {
        ArrayList<String> secrets = new ArrayList<String>();
        ModelNode node = this.get(SERVICE_ACCOUNT_SECRETS);
        if (node.getType() != ModelType.LIST) {
            return secrets;
        }
        for (ModelNode entry : node.asList()) {
            secrets.add(this.asString(entry, "name"));
        }
        return secrets;
    }

    @Override
    public void addSecret(String secret) {
        ModelNode secretNodeName = this.get(SERVICE_ACCOUNT_SECRETS).add();
        this.set(secretNodeName, "name", secret);
    }

    @Override
    public Collection<String> getImagePullSecrets() {
        ArrayList<String> secrets = new ArrayList<String>();
        ModelNode node = this.get(SERVICE_ACCOUNT_IMAGE_PULL_SECRETS);
        if (node.getType() != ModelType.LIST) {
            return secrets;
        }
        for (ModelNode entry : node.asList()) {
            secrets.add(this.asString(entry, "name"));
        }
        return secrets;
    }

    @Override
    public void addImagePullSecret(String imagePullSecret) {
        ModelNode secretNodeName = this.get(SERVICE_ACCOUNT_IMAGE_PULL_SECRETS).add();
        this.set(secretNodeName, "name", imagePullSecret);
    }
}

