/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.util;

import com.github.dockerjava.api.exception.DockerClientException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class FilePathUtil {
    private FilePathUtil() {
    }

    public static String relativize(File baseDir, File file) {
        try {
            baseDir = baseDir.getCanonicalFile();
            file = file.getCanonicalFile();
            return baseDir.toURI().relativize(file.toURI()).getPath();
        }
        catch (IOException e) {
            throw new DockerClientException(e.getMessage(), (Throwable)e);
        }
    }

    public static String relativize(Path baseDir, Path file) {
        String path = baseDir.toUri().relativize(file.toUri()).getPath();
        if (!"/".equals(baseDir.getFileSystem().getSeparator())) {
            return path.replace(baseDir.getFileSystem().getSeparator(), "/");
        }
        return path;
    }
}

