/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.zeroturnaround.exec.InvalidExitValueException;
import org.testcontainers.shaded.org.zeroturnaround.exec.ProcessExecutor;
import org.testcontainers.shaded.org.zeroturnaround.exec.ProcessResult;

public class CommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLine.class);

    public static String runShellCommand(String ... command) {
        String joinedCommand = String.join((CharSequence)" ", command);
        LOGGER.debug("Executing shell command: `{}`", (Object)joinedCommand);
        try {
            ProcessResult result = new ProcessExecutor().command(command).readOutput(true).exitValueNormal().execute();
            return result.outputUTF8().trim();
        }
        catch (IOException | InterruptedException | TimeoutException | InvalidExitValueException e) {
            throw new ShellCommandException("Exception when executing " + joinedCommand, e);
        }
    }

    public static boolean executableExists(String executable) {
        File directFile = new File(executable);
        if (directFile.exists() && directFile.canExecute()) {
            return true;
        }
        for (String pathString : CommandLine.getSystemPath()) {
            Path path = Paths.get(pathString, new String[0]);
            if (!Files.exists(path.resolve(executable), new LinkOption[0]) || !Files.isExecutable(path.resolve(executable))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String[] getSystemPath() {
        return System.getenv("PATH").split(Pattern.quote(File.pathSeparator));
    }

    private static class ShellCommandException
    extends RuntimeException {
        public ShellCommandException(String message, Exception e) {
            super(message, e);
        }
    }
}

