/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Network;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.utility.JVMHookResourceReaper;
import org.testcontainers.utility.RyukResourceReaper;

public class ResourceReaper {
    private static final Logger log = LoggerFactory.getLogger(ResourceReaper.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceReaper.class);
    private static final Map<String, String> MARKER_LABELS = Collections.singletonMap(DockerClientFactory.TESTCONTAINERS_SESSION_ID_LABEL, DockerClientFactory.SESSION_ID);
    static final List<List<Map.Entry<String, String>>> DEATH_NOTE = new ArrayList<List>(Arrays.asList(Stream.concat(DockerClientFactory.DEFAULT_LABELS.entrySet().stream(), MARKER_LABELS.entrySet().stream()).map(it -> new AbstractMap.SimpleEntry<String, String>("label", (String)it.getKey() + "=" + (String)it.getValue())).collect(Collectors.toList())));
    private static ResourceReaper instance;
    final DockerClient dockerClient = DockerClientFactory.lazyClient();
    private Map<String, String> registeredContainers = new ConcurrentHashMap<String, String>();
    private Set<String> registeredNetworks = Sets.newConcurrentHashSet();
    private Set<String> registeredImages = Sets.newConcurrentHashSet();
    private AtomicBoolean hookIsSet = new AtomicBoolean(false);

    ResourceReaper() {
    }

    public static synchronized ResourceReaper instance() {
        if (instance == null) {
            boolean useRyuk = !Boolean.parseBoolean(System.getenv("TESTCONTAINERS_RYUK_DISABLED"));
            instance = useRyuk ? new RyukResourceReaper() : new JVMHookResourceReaper();
        }
        return instance;
    }

    @Deprecated
    public void performCleanup() {
        this.registeredContainers.forEach(this::removeContainer);
        this.registeredNetworks.forEach(this::removeNetwork);
        this.registeredImages.forEach(this::removeImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registerFilterForCleanup(List<Map.Entry<String, String>> filter) {
        List<List<Map.Entry<String, String>>> list = DEATH_NOTE;
        synchronized (list) {
            DEATH_NOTE.add(filter);
            DEATH_NOTE.notifyAll();
        }
    }

    public void registerLabelsFilterForCleanup(Map<String, String> labels) {
        this.registerFilterForCleanup(labels.entrySet().stream().map(it -> new AbstractMap.SimpleEntry<String, String>("label", (String)it.getKey() + "=" + (String)it.getValue())).collect(Collectors.toList()));
    }

    @Deprecated
    public void registerContainerForCleanup(String containerId, String imageName) {
        this.setHook();
        this.registeredContainers.put(containerId, imageName);
    }

    @Deprecated
    public void stopAndRemoveContainer(String containerId) {
        this.removeContainer(containerId, this.registeredContainers.get(containerId));
        this.registeredContainers.remove(containerId);
    }

    @Deprecated
    public void stopAndRemoveContainer(String containerId, String imageName) {
        this.removeContainer(containerId, imageName);
        this.registeredContainers.remove(containerId);
    }

    private void removeContainer(String containerId, String imageName) {
        boolean running;
        try {
            InspectContainerResponse containerInfo = this.dockerClient.inspectContainerCmd(containerId).exec();
            running = containerInfo.getState() != null && Boolean.TRUE.equals(containerInfo.getState().getRunning());
        }
        catch (NotFoundException e) {
            LOGGER.trace("Was going to stop container but it apparently no longer exists: {}", (Object)containerId);
            return;
        }
        catch (Exception e) {
            LOGGER.trace("Error encountered when checking container for shutdown (ID: {}) - it may not have been stopped, or may already be stopped. Root cause: {}", (Object)containerId, (Object)Throwables.getRootCause(e).getMessage());
            return;
        }
        if (running) {
            try {
                LOGGER.trace("Stopping container: {}", (Object)containerId);
                this.dockerClient.killContainerCmd(containerId).exec();
                LOGGER.trace("Stopped container: {}", (Object)imageName);
            }
            catch (Exception e) {
                LOGGER.trace("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped. Root cause: {}", (Object)containerId, (Object)Throwables.getRootCause(e).getMessage());
            }
        }
        try {
            this.dockerClient.inspectContainerCmd(containerId).exec();
        }
        catch (Exception e) {
            LOGGER.trace("Was going to remove container but it apparently no longer exists: {}", (Object)containerId);
            return;
        }
        try {
            LOGGER.trace("Removing container: {}", (Object)containerId);
            this.dockerClient.removeContainerCmd(containerId).withRemoveVolumes(Boolean.valueOf(true)).withForce(Boolean.valueOf(true)).exec();
            LOGGER.debug("Removed container and associated volume(s): {}", (Object)imageName);
        }
        catch (Exception e) {
            LOGGER.trace("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped. Root cause: {}", (Object)containerId, (Object)Throwables.getRootCause(e).getMessage());
        }
    }

    @Deprecated
    public void registerNetworkIdForCleanup(String id) {
        this.setHook();
        this.registeredNetworks.add(id);
    }

    @Deprecated
    public void removeNetworkById(String id) {
        this.removeNetwork(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNetwork(String id) {
        try {
            List networks;
            try {
                networks = (List)this.dockerClient.listNetworksCmd().withIdFilter(new String[]{id}).exec();
            }
            catch (Exception e) {
                LOGGER.trace("Error encountered when looking up network for removal (name: {}) - it may not have been removed", (Object)id);
                this.registeredNetworks.remove(id);
                return;
            }
            for (Network network : networks) {
                try {
                    this.dockerClient.removeNetworkCmd(network.getId()).exec();
                    this.registeredNetworks.remove(network.getId());
                    LOGGER.debug("Removed network: {}", (Object)id);
                }
                catch (Exception e) {
                    LOGGER.trace("Error encountered removing network (name: {}) - it may not have been removed", (Object)network.getName());
                }
            }
        }
        finally {
            this.registeredNetworks.remove(id);
        }
    }

    @Deprecated
    public void unregisterNetwork(String identifier) {
        this.registeredNetworks.remove(identifier);
    }

    @Deprecated
    public void unregisterContainer(String identifier) {
        this.registeredContainers.remove(identifier);
    }

    @Deprecated
    public void registerImageForCleanup(String dockerImageName) {
        this.setHook();
        this.registeredImages.add(dockerImageName);
    }

    private void removeImage(String dockerImageName) {
        LOGGER.trace("Removing image tagged {}", (Object)dockerImageName);
        try {
            this.dockerClient.removeImageCmd(dockerImageName).withForce(Boolean.valueOf(true)).exec();
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to delete image " + dockerImageName, e);
        }
    }

    void setHook() {
        if (this.hookIsSet.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, this::performCleanup));
        }
    }

    @Deprecated
    public Map<String, String> getLabels() {
        return MARKER_LABELS;
    }

    @Deprecated
    public CreateContainerCmd register(GenericContainer<?> container, CreateContainerCmd cmd) {
        cmd.getLabels().putAll(this.getLabels());
        return cmd;
    }

    @Deprecated
    public void init() {
    }

    static class FilterRegistry {
        @VisibleForTesting
        static final String ACKNOWLEDGMENT = "ACK";
        private final BufferedReader in;
        private final OutputStream out;

        FilterRegistry(InputStream ryukInputStream, OutputStream ryukOutputStream) {
            this.in = new BufferedReader(new InputStreamReader(ryukInputStream));
            this.out = ryukOutputStream;
        }

        protected boolean register(List<Map.Entry<String, String>> filters) throws IOException {
            String query = filters.stream().map(it -> {
                try {
                    return URLEncoder.encode((String)it.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)it.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.joining("&"));
            log.debug("Sending '{}' to Ryuk", (Object)query);
            this.out.write(query.getBytes());
            this.out.write(10);
            this.out.flush();
            return FilterRegistry.waitForAcknowledgment(this.in);
        }

        private static boolean waitForAcknowledgment(BufferedReader in) throws IOException {
            String line = in.readLine();
            while (line != null && !ACKNOWLEDGMENT.equalsIgnoreCase(line)) {
                line = in.readLine();
            }
            return ACKNOWLEDGMENT.equalsIgnoreCase(line);
        }
    }
}

