/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.exception.ConnectionCreationException;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;

public class ContainerLessJdbcDelegate
extends JdbcDatabaseDelegate {
    private static final Logger log = LoggerFactory.getLogger(ContainerLessJdbcDelegate.class);
    private Connection connection;

    public ContainerLessJdbcDelegate(Connection connection) {
        super(null, "");
        this.connection = connection;
    }

    @Override
    protected Statement createNewConnection() {
        try {
            return this.connection.createStatement();
        }
        catch (SQLException e) {
            log.error("Could create JDBC statement");
            throw new ConnectionCreationException("Could create JDBC statement", (Throwable)e);
        }
    }
}

