/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowCallback;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.util.AcrStore;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ConditionalLoaAuthenticator
implements ConditionalAuthenticator,
AuthenticationFlowCallback {
    public static final String LEVEL = "loa-condition-level";
    public static final String MAX_AGE = "loa-max-age";
    public static final int DEFAULT_MAX_AGE = 36000;
    @Deprecated
    public static final String STORE_IN_USER_SESSION = "loa-store-in-user-session";
    private static final Logger logger = Logger.getLogger(ConditionalLoaAuthenticator.class);
    private final KeycloakSession session;

    public ConditionalLoaAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        AcrStore acrStore = new AcrStore(authSession);
        int currentAuthenticationLoa = acrStore.getLevelOfAuthenticationFromCurrentAuthentication();
        Integer configuredLoa = this.getConfiguredLoa(context);
        if (configuredLoa == null) {
            configuredLoa = 0;
        }
        int requestedLoa = acrStore.getRequestedLevelOfAuthentication();
        if (currentAuthenticationLoa < 0) {
            logger.tracef("Condition '%s' evaluated to true due the user not yet reached any authentication level in this session, configuredLoa: %d, requestedLoa: %d", (Object)context.getAuthenticatorConfig().getAlias(), (Object)configuredLoa, (Object)requestedLoa);
            return true;
        }
        if (requestedLoa < configuredLoa) {
            logger.tracef("Condition '%s' evaluated to false due the requestedLoa '%d' smaller than configuredLoa '%d'. CurrentAuthenticationLoa: %d", new Object[]{context.getAuthenticatorConfig().getAlias(), requestedLoa, configuredLoa, currentAuthenticationLoa});
            return false;
        }
        int maxAge = this.getMaxAge(context);
        boolean previouslyAuthenticated = acrStore.isLevelAuthenticatedInPreviousAuth(configuredLoa, maxAge);
        if (previouslyAuthenticated && currentAuthenticationLoa < configuredLoa) {
            acrStore.setLevelAuthenticatedToCurrentRequest(configuredLoa);
        }
        logger.tracef("Checking condition '%s' : currentAuthenticationLoa: %d, requestedLoa: %d, configuredLoa: %d, evaluation result: %b", new Object[]{context.getAuthenticatorConfig().getAlias(), currentAuthenticationLoa, requestedLoa, configuredLoa, !previouslyAuthenticated});
        return !previouslyAuthenticated;
    }

    public void onParentFlowSuccess(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        AcrStore acrStore = new AcrStore(authSession);
        Integer newLoa = this.getConfiguredLoa(context);
        if (newLoa == null) {
            return;
        }
        int maxAge = this.getMaxAge(context);
        if (maxAge == 0) {
            logger.tracef("Skip updating authenticated level '%d' in condition '%s' for future authentications due max-age set to 0", (Object)newLoa, (Object)context.getAuthenticatorConfig().getAlias());
            acrStore.setLevelAuthenticatedToCurrentRequest(newLoa);
        } else {
            logger.tracef("Updating LoA to '%d' in the condition '%s' when authenticating session '%s'. Max age is %d.", new Object[]{newLoa, context.getAuthenticatorConfig().getAlias(), authSession.getParentSession().getId(), maxAge});
            acrStore.setLevelAuthenticated(newLoa);
        }
    }

    public void onTopFlowSuccess() {
        AuthenticationSessionModel authSession = this.session.getContext().getAuthenticationSession();
        AcrStore acrStore = new AcrStore(authSession);
        logger.tracef("Finished authentication at level %d when authenticating authSession '%s'.", acrStore.getLevelOfAuthenticationFromCurrentAuthentication(), (Object)authSession.getParentSession().getId());
        if (acrStore.isLevelOfAuthenticationForced() && !acrStore.isLevelOfAuthenticationSatisfiedFromCurrentAuthentication()) {
            String details = String.format("Forced level of authentication did not meet the requirements. Requested level: %d, Fulfilled level: %d", acrStore.getRequestedLevelOfAuthentication(), acrStore.getLevelOfAuthenticationFromCurrentAuthentication());
            throw new AuthenticationFlowException(AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR, details, "acrNotFulfilled");
        }
        logger.tracef("Updating authenticated levels in authSession '%s' to user session note for future authentications: %s", (Object)authSession.getParentSession().getId(), (Object)authSession.getAuthNote("loa-map"));
        authSession.setUserSessionNote("loa-map", authSession.getAuthNote("loa-map"));
    }

    private Integer getConfiguredLoa(AuthenticationFlowContext context) {
        return LoAUtil.getLevelFromLoaConditionConfiguration(context.getAuthenticatorConfig());
    }

    private int getMaxAge(AuthenticationFlowContext context) {
        return LoAUtil.getMaxAgeFromLoaConditionConfiguration(context.getAuthenticatorConfig());
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

