/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class LoginFormsUtil {
    public static List<IdentityProviderModel> filterIdentityProvidersForTheme(Stream<IdentityProviderModel> providers, KeycloakSession session, AuthenticationFlowContext context) {
        if (context != null) {
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            String currentFlowPath = authSession.getAuthNote("current.flow.path");
            UserModel currentUser = context.getUser();
            if (currentUser != null || Objects.equals("first-broker-login", currentFlowPath)) {
                return LoginFormsUtil.filterIdentityProviders(providers, session, context);
            }
        }
        return providers.collect(Collectors.toList());
    }

    public static List<IdentityProviderModel> filterIdentityProviders(Stream<IdentityProviderModel> providers, KeycloakSession session, AuthenticationFlowContext context) {
        if (context != null) {
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, "BROKERED_CONTEXT");
            IdentityProviderModel existingIdp = serializedCtx == null ? null : serializedCtx.deserialize(session, authSession).getIdpConfig();
            Set federatedIdentities = context.getUser() != null ? session.users().getFederatedIdentitiesStream(session.getContext().getRealm(), context.getUser()).map(federatedIdentityModel -> federatedIdentityModel.getIdentityProvider()).collect(Collectors.toSet()) : null;
            return providers.filter(p -> {
                if (existingIdp == null) {
                    return true;
                }
                return !Objects.equals(p.getAlias(), existingIdp.getAlias());
            }).filter(idp -> {
                if (federatedIdentities == null) {
                    return true;
                }
                return federatedIdentities.contains(idp.getAlias());
            }).collect(Collectors.toList());
        }
        return providers.collect(Collectors.toList());
    }
}

