/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.keycloak.models.RealmModel;

public class RealmBean {
    private RealmModel realm;

    public RealmBean(RealmModel realmModel) {
        this.realm = realmModel;
    }

    public String getName() {
        return this.realm.getName();
    }

    public String getDisplayName() {
        String displayName = this.realm.getDisplayName();
        if (displayName != null && displayName.length() > 0) {
            return displayName;
        }
        return this.getName();
    }

    public String getDisplayNameHtml() {
        String displayNameHtml = this.realm.getDisplayNameHtml();
        if (displayNameHtml != null && displayNameHtml.length() > 0) {
            return displayNameHtml;
        }
        return this.getDisplayName();
    }

    public boolean isIdentityFederationEnabled() {
        return this.realm.isIdentityFederationEnabled();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public boolean isLoginWithEmailAllowed() {
        return this.realm.isLoginWithEmailAllowed();
    }

    public boolean isDuplicateEmailsAllowed() {
        return this.realm.isDuplicateEmailsAllowed();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public boolean isPassword() {
        return this.realm.getRequiredCredentialsStream().anyMatch(r -> Objects.equals(r.getType(), "password"));
    }

    public int getActionTokenGeneratedByUserLifespanMinutes() {
        return (int)TimeUnit.SECONDS.toMinutes(this.realm.getActionTokenGeneratedByUserLifespan());
    }

    public int getVerifyEmailActionTokenLifespanMinutes() {
        return (int)TimeUnit.SECONDS.toMinutes(this.realm.getActionTokenGeneratedByUserLifespan("verify-email"));
    }

    public int getResetCredentialsActionTokenLifespanMinutes() {
        return (int)TimeUnit.SECONDS.toMinutes(this.realm.getActionTokenGeneratedByUserLifespan("reset-credentials"));
    }

    public int getIdpVerifyAccountLinkActionTokenLifespanMinutes() {
        return (int)TimeUnit.SECONDS.toMinutes(this.realm.getActionTokenGeneratedByUserLifespan("idp-verify-account-via-email"));
    }
}

