/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;

public class AuthzEndpointQueryStringParser
extends AuthzEndpointRequestParser {
    private static final Logger logger = Logger.getLogger(AuthzEndpointRequestParser.class);
    private final MultivaluedMap<String, String> requestParams;
    private final boolean isResponseTypeParameterRequired;
    private String invalidRequestMessage = null;

    public AuthzEndpointQueryStringParser(MultivaluedMap<String, String> requestParams, boolean isResponseTypeParameterRequired) {
        this.requestParams = requestParams;
        this.isResponseTypeParameterRequired = isResponseTypeParameterRequired;
    }

    @Override
    protected void validateResponseTypeParameter(String responseTypeParameter, AuthorizationEndpointRequest request) {
        if (this.isResponseTypeParameterRequired && responseTypeParameter == null) {
            logger.warn((Object)"Missing parameter 'response_type' in the OAuth 2.0 request parameters");
            this.invalidRequestMessage = "Missing parameter: response_type";
        }
        super.validateResponseTypeParameter(responseTypeParameter, request);
    }

    @Override
    protected String getParameter(String paramName) {
        this.checkDuplicated(this.requestParams, paramName);
        return (String)this.requestParams.getFirst((Object)paramName);
    }

    @Override
    protected Integer getIntParameter(String paramName) {
        this.checkDuplicated(this.requestParams, paramName);
        String paramVal = (String)this.requestParams.getFirst((Object)paramName);
        return paramVal == null ? null : Integer.valueOf(paramVal);
    }

    public String getInvalidRequestMessage() {
        return this.invalidRequestMessage;
    }

    @Override
    protected Set<String> keySet() {
        return this.requestParams.keySet();
    }

    private void checkDuplicated(MultivaluedMap<String, String> requestParams, String paramName) {
        if (this.invalidRequestMessage == null && requestParams.get((Object)paramName) != null && ((List)requestParams.get((Object)paramName)).size() != 1) {
            this.invalidRequestMessage = "duplicated parameter";
        }
    }
}

