/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.par.endpoints;

import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpointChecker;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.par.ParResponse;
import org.keycloak.protocol.oidc.par.clientpolicy.context.PushedAuthorizationRequestContext;
import org.keycloak.protocol.oidc.par.endpoints.AbstractParEndpoint;
import org.keycloak.protocol.oidc.par.endpoints.ParRootEndpoint;
import org.keycloak.protocol.oidc.par.endpoints.request.ParEndpointRequestParserProcessor;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.resources.Cors;
import org.keycloak.utils.ProfileHelper;

public class ParEndpoint
extends AbstractParEndpoint {
    public static final String PAR_CREATED_TIME = "par.created.time";
    private static final String REQUEST_URI_PREFIX = "urn:ietf:params:oauth:request_uri:";
    public static final int REQUEST_URI_PREFIX_LENGTH = "urn:ietf:params:oauth:request_uri:".length();
    private final HttpRequest httpRequest;
    private AuthorizationEndpointRequest authorizationRequest;

    public static UriBuilder parUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "resolveExtension").resolveTemplate("extension", (Object)"par", false).path(ParRootEndpoint.class, "request");
    }

    public ParEndpoint(KeycloakSession session, EventBuilder event) {
        super(session, event);
        this.httpRequest = session.getContext().getHttpRequest();
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response request() {
        ProfileHelper.requireFeature(Profile.Feature.PAR);
        this.cors = Cors.add(this.httpRequest).auth().allowedMethods("POST").auth().exposedHeaders("Access-Control-Allow-Methods");
        this.event.event(EventType.PUSHED_AUTHORIZATION_REQUEST);
        this.checkSsl();
        this.checkRealm();
        this.authorizeClient();
        if (this.httpRequest.getDecodedFormParameters().containsKey((Object)"request_uri")) {
            throw this.throwErrorResponseException("invalid_request", "It is not allowed to include request_uri to PAR.", Response.Status.BAD_REQUEST);
        }
        try {
            this.authorizationRequest = ParEndpointRequestParserProcessor.parseRequest(this.event, this.session, this.client, (MultivaluedMap<String, String>)this.httpRequest.getDecodedFormParameters());
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request_object", e.getMessage(), Response.Status.BAD_REQUEST);
        }
        AuthorizationEndpointChecker checker = new AuthorizationEndpointChecker().event(this.event).client(this.client).realm(this.realm).request(this.authorizationRequest).session(this.session);
        try {
            checker.checkRedirectUri();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            throw this.throwErrorResponseException("invalid_request", "Invalid parameter: redirect_uri", Response.Status.BAD_REQUEST);
        }
        try {
            checker.checkResponseType();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            if (ex.getError().equals("unsupported_response_type")) {
                throw this.throwErrorResponseException("invalid_request", "Unsupported response type", Response.Status.BAD_REQUEST);
            }
            ex.throwAsCorsErrorResponseException(this.cors);
        }
        try {
            checker.checkValidScope();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            throw this.throwErrorResponseException("invalid_request", ex.getErrorDescription(), Response.Status.BAD_REQUEST);
        }
        try {
            checker.checkInvalidRequestMessage();
            checker.checkOIDCRequest();
            checker.checkOIDCParams();
            checker.checkPKCEParams();
        }
        catch (AuthorizationEndpointChecker.AuthorizationCheckException ex) {
            ex.throwAsCorsErrorResponseException(this.cors);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new PushedAuthorizationRequestContext(this.authorizationRequest, (MultivaluedMap<String, String>)this.httpRequest.getDecodedFormParameters()));
        }
        catch (ClientPolicyException cpe) {
            throw this.throwErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String key = UUID.randomUUID().toString();
        String requestUri = REQUEST_URI_PREFIX + key;
        int expiresIn = this.realm.getParPolicy().getRequestUriLifespan();
        this.httpRequest.getDecodedFormParameters().forEach((k, v) -> {
            String singleValue = String.valueOf(v).replace("[", "").replace("]", "");
            params.put((String)k, singleValue);
        });
        params.put(PAR_CREATED_TIME, String.valueOf(System.currentTimeMillis()));
        SingleUseObjectProvider singleUseStore = (SingleUseObjectProvider)this.session.getProvider(SingleUseObjectProvider.class);
        singleUseStore.put(key, (long)expiresIn, params);
        ParResponse parResponse = new ParResponse(requestUri, expiresIn);
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
        return this.cors.builder(Response.status((Response.Status)Response.Status.CREATED).entity((Object)parResponse).type(MediaType.APPLICATION_JSON_TYPE)).build();
    }
}

