/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.security.Key;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.PemUtils;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.account.AccountFormService;

public class PublicRealmResource {
    protected static final Logger logger = Logger.getLogger(PublicRealmResource.class);
    protected final HttpRequest request;
    protected final HttpResponse response;
    protected final KeycloakSession session;
    protected final RealmModel realm;

    public PublicRealmResource(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.request = session.getContext().getHttpRequest();
        this.response = session.getContext().getHttpResponse();
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public PublishedRealmRepresentation getRealm() {
        Cors.add(this.request).allowedOrigins("*").auth().build(this.response);
        return PublicRealmResource.realmRep(this.session, this.realm, (UriInfo)this.session.getContext().getUri());
    }

    public static PublishedRealmRepresentation realmRep(KeycloakSession session, RealmModel realm, UriInfo uriInfo) {
        PublishedRealmRepresentation rep = new PublishedRealmRepresentation();
        rep.setRealm(realm.getName());
        rep.setTokenServiceUrl(OIDCLoginProtocolService.tokenServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setAccountServiceUrl(AccountFormService.accountServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setPublicKeyPem(PemUtils.encodeKey((Key)session.keys().getActiveRsaKey(realm).getPublicKey()));
        rep.setNotBefore(realm.getNotBefore());
        return rep;
    }
}

