/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class QuarkusResteasySecurityContext
implements SecurityContext {
    private final HttpServerRequest request;
    private final RoutingContext routingContext;

    public QuarkusResteasySecurityContext(HttpServerRequest request, RoutingContext routingContext) {
        this.request = request;
        this.routingContext = routingContext;
    }

    public Principal getUserPrincipal() {
        QuarkusHttpUser user = (QuarkusHttpUser)this.routingContext.user();
        if (user == null || user.getSecurityIdentity().isAnonymous()) {
            return null;
        }
        return user.getSecurityIdentity().getPrincipal();
    }

    public boolean isUserInRole(String role) {
        SecurityIdentity user = CurrentIdentityAssociation.current();
        if (role.equals("**")) {
            return !user.isAnonymous();
        }
        return user.hasRole(role);
    }

    public boolean isSecure() {
        return this.request.isSSL();
    }

    public String getAuthenticationScheme() {
        String authorizationValue = this.request.getHeader("Authorization");
        if (authorizationValue == null) {
            return null;
        }
        return authorizationValue.split(" ")[0].trim();
    }
}

