/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import java.util.List;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.OidcSecurityContext;

public class AuthenticatedActionsHandler {
    private OidcClientConfiguration deployment;
    private OidcHttpFacade facade;

    public AuthenticatedActionsHandler(OidcClientConfiguration deployment, OidcHttpFacade facade) {
        this.deployment = deployment;
        this.facade = facade;
    }

    public boolean handledRequest() {
        ElytronMessages.log.debugv("AuthenticatedActionsValve.invoke {0}", (Object)this.facade.getRequest().getURI());
        if (this.corsRequest()) {
            return true;
        }
        String requestUri = this.facade.getRequest().getURI();
        if (requestUri.endsWith("k_query_bearer_token")) {
            this.queryBearerToken();
            return true;
        }
        return false;
    }

    protected void queryBearerToken() {
        ElytronMessages.log.debugv("queryBearerToken {0}", (Object)this.facade.getRequest().getURI());
        if (this.abortTokenResponse()) {
            return;
        }
        this.facade.getResponse().setStatus(200);
        this.facade.getResponse().setHeader("Content-Type", "text/plain");
        try {
            this.facade.getResponse().getOutputStream().write(this.facade.getSecurityContext().getTokenString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.facade.getResponse().end();
    }

    protected boolean abortTokenResponse() {
        if (this.facade.getSecurityContext() == null) {
            ElytronMessages.log.debugv("Not logged in, sending back 401: {0}", (Object)this.facade.getRequest().getURI());
            this.facade.getResponse().sendError(401);
            this.facade.getResponse().end();
            return true;
        }
        if (!this.deployment.isExposeToken()) {
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().end();
            return true;
        }
        String origin = this.facade.getRequest().getHeader("Origin");
        if (!this.deployment.isCors() && origin != null && !origin.equals("null")) {
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().end();
            return true;
        }
        return false;
    }

    protected boolean corsRequest() {
        if (!this.deployment.isCors()) {
            return false;
        }
        OidcSecurityContext securityContext = this.facade.getSecurityContext();
        String origin = this.facade.getRequest().getHeader("Origin");
        origin = "null".equals(origin) ? null : origin;
        String exposeHeaders = this.deployment.getCorsExposedHeaders();
        String requestOrigin = AuthenticatedActionsHandler.getOrigin(this.facade.getRequest().getURI());
        ElytronMessages.log.debugv("Origin: {0} uri: {1}", (Object)origin, (Object)this.facade.getRequest().getURI());
        if (securityContext != null && origin != null && !origin.equals(requestOrigin)) {
            AccessToken token = securityContext.getToken();
            List<String> allowedOrigins = token.getAllowedOrigins();
            ElytronMessages.log.debugf("Allowed origins in token: %s", (Object)allowedOrigins);
            if (allowedOrigins == null || !allowedOrigins.contains("*") && !allowedOrigins.contains(origin)) {
                if (allowedOrigins == null) {
                    ElytronMessages.log.debugv("allowedOrigins was null in token", new Object[0]);
                } else {
                    ElytronMessages.log.debugv("allowedOrigins did not contain origin", new Object[0]);
                }
                this.facade.getResponse().sendError(403);
                this.facade.getResponse().end();
                return true;
            }
            ElytronMessages.log.debugv("returning origin: {0}", (Object)origin);
            this.facade.getResponse().setStatus(200);
            this.facade.getResponse().setHeader("Access-Control-Allow-Origin", origin);
            this.facade.getResponse().setHeader("Access-Control-Allow-Credentials", "true");
            if (exposeHeaders != null) {
                this.facade.getResponse().setHeader("Access-Control-Expose-Headers", exposeHeaders);
            }
        } else {
            ElytronMessages.log.debugv("cors validation not needed as we are not a secure session or origin header was null: {0}", (Object)this.facade.getRequest().getURI());
        }
        return false;
    }

    private static String getOrigin(String uri) {
        String u = uri;
        int e = u.indexOf(47, 8);
        return e != -1 ? u.substring(0, u.indexOf(47, 8)) : u;
    }
}

