/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.attribute;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public interface Attributes {
    public static Attributes from(Map<String, Collection<String>> attributes) {
        return () -> attributes;
    }

    public Map<String, Collection<String>> toMap();

    default public boolean exists(String name) {
        return this.toMap().containsKey(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean containsValue(String name, String value) {
        Collection<String> values = this.toMap().get(name);
        if (values == null) return false;
        if (!values.stream().anyMatch(value::equals)) return false;
        return true;
    }

    default public Entry getValue(String name) {
        Collection<String> value = this.toMap().get(name);
        if (value != null) {
            return new Entry(name, value);
        }
        return null;
    }

    public static class Entry {
        private final String[] values;
        private final String name;

        public Entry(String name, Collection<String> values) {
            this.name = name;
            this.values = values.toArray(new String[values.size()]);
        }

        private String getName() {
            return this.name;
        }

        public int size() {
            return this.values.length;
        }

        public boolean isEmpty() {
            return this.values.length == 0;
        }

        public String asString(int idx) {
            if (idx >= this.values.length) {
                throw new IllegalArgumentException("Invalid index [" + idx + "]. Values are [" + this.values + "].");
            }
            return this.values[idx];
        }

        public int asInt(int idx) {
            return Integer.parseInt(this.asString(idx));
        }

        public Date asDate(int idx, String pattern) {
            try {
                return new SimpleDateFormat(pattern).parse(this.asString(idx));
            }
            catch (ParseException e) {
                throw new RuntimeException("Error parsing date.", e);
            }
        }

        public InetAddress asInetAddress(int idx) {
            try {
                return InetAddress.getByName(this.asString(idx));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Error parsing address.", e);
            }
        }

        public long asLong(int idx) {
            return Long.parseLong(this.asString(idx));
        }

        public double asDouble(int idx) {
            return Double.parseDouble(this.asString(idx));
        }
    }
}

