/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapAuthenticatorConfigEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapAuthenticatorConfigEntity fromModel(AuthenticatorConfigModel model) {
        if (model == null) {
            return null;
        }
        MapAuthenticatorConfigEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapAuthenticatorConfigEntity.class);
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setConfig(model.getConfig());
        return entity;
    }

    public static AuthenticatorConfigModel toModel(MapAuthenticatorConfigEntity entity) {
        if (entity == null) {
            return null;
        }
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public String getAlias();

    public void setAlias(String var1);

    public Map<String, String> getConfig();

    public void setConfig(Map<String, String> var1);
}

