/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.request;

import javax.ws.rs.BadRequestException;

public final class QualityValue
extends Number
implements Comparable<QualityValue> {
    public static final QualityValue NOT_ACCEPTABLE = new QualityValue(0);
    public static final QualityValue LOWEST = new QualityValue(1);
    public static final QualityValue HIGHEST;
    public static final QualityValue DEFAULT;
    private static final long serialVersionUID = 1L;
    private static final String MALFORMED_VALUE_MESSAGE = "Malformed quality value.";
    private final int WEIGHT;

    private QualityValue(int weight) {
        assert (weight >= 0);
        assert (weight <= 1000);
        this.WEIGHT = weight;
    }

    public static QualityValue valueOf(String qvalue) {
        if (qvalue == null) {
            return DEFAULT;
        }
        return new QualityValue(QualityValue.parseAsInteger(qvalue));
    }

    public boolean isPrefered() {
        return this.WEIGHT == QualityValue.HIGHEST.WEIGHT;
    }

    public boolean isAcceptable() {
        return this.WEIGHT != QualityValue.NOT_ACCEPTABLE.WEIGHT;
    }

    @Override
    public int compareTo(QualityValue o) {
        return this.WEIGHT - o.WEIGHT;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != QualityValue.class) {
            return false;
        }
        QualityValue other = (QualityValue)o;
        return this.WEIGHT == other.WEIGHT;
    }

    public int hashCode() {
        return this.WEIGHT;
    }

    @Override
    public double doubleValue() {
        return (double)this.WEIGHT / 1000.0;
    }

    @Override
    public float floatValue() {
        return (float)this.WEIGHT / 1000.0f;
    }

    @Override
    public int intValue() {
        return this.WEIGHT;
    }

    @Override
    public long longValue() {
        return this.WEIGHT;
    }

    private static int parseAsInteger(String value) {
        int length = value.length();
        if (length == 0 || length > 5) {
            throw new BadRequestException(MALFORMED_VALUE_MESSAGE);
        }
        if (length > 1 && value.charAt(1) != '.') {
            throw new BadRequestException(MALFORMED_VALUE_MESSAGE);
        }
        int firstCharacter = value.codePointAt(0);
        if (firstCharacter == 49) {
            for (int i = 2; i < length; ++i) {
                if (value.charAt(i) == '0') continue;
                throw new BadRequestException(MALFORMED_VALUE_MESSAGE);
            }
            return 1000;
        }
        if (firstCharacter == 48) {
            int weight = 0;
            for (int i = 2; i < 5; ++i) {
                weight *= 10;
                if (i >= length) continue;
                int digit = value.codePointAt(i) - 48;
                if (digit < 0 || digit > 9) {
                    throw new BadRequestException(MALFORMED_VALUE_MESSAGE);
                }
                weight += digit;
            }
            return weight;
        }
        throw new BadRequestException(MALFORMED_VALUE_MESSAGE);
    }

    static {
        DEFAULT = HIGHEST = new QualityValue(1000);
    }
}

