/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import org.jfree.report.util.WorkerPool;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public final class Worker
extends Thread {
    private Runnable workload;
    private volatile boolean finish;
    private WorkerPool workerPool;

    public Worker() {
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkload(Runnable runnable) {
        if (this.workload != null) {
            throw new IllegalStateException("This worker is not idle.");
        }
        Worker worker = this;
        synchronized (worker) {
            this.workload = runnable;
            this.notifyAll();
        }
    }

    public synchronized Runnable getWorkload() {
        return this.workload;
    }

    public void finish() {
        this.finish = true;
        try {
            this.interrupt();
            this.notifyAll();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.workerPool != null) {
            this.workerPool.workerFinished(this);
        }
    }

    public boolean isAvailable() {
        return this.workload == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (!this.finish) {
            if (this.workload != null) {
                try {
                    this.workload.run();
                }
                catch (Exception exception) {
                    DebugLog.log((Object)"Worker caught exception on run: ", (Throwable)exception);
                }
                this.workload = null;
                if (this.workerPool != null) {
                    this.workerPool.workerAvailable(this);
                }
            }
            Worker worker = this;
            synchronized (worker) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isFinish() {
        return this.finish;
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }
}

