/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNameContainer;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;

public class DatabaseControl
extends Control {
    private int m_nFieldType;

    public DatabaseControl(GridControl gridControl, FieldColumn fieldColumn) {
        if (fieldColumn.getFieldType() != 93) {
            this.createGridColumn(gridControl, fieldColumn, fieldColumn.getFieldType(), fieldColumn.getFieldTitle());
        }
    }

    public DatabaseControl(GridControl gridControl, FieldColumn fieldColumn, int n, String string) {
        this.createGridColumn(gridControl, fieldColumn, n, string);
    }

    private int getFieldType() {
        return this.m_nFieldType;
    }

    private void createGridColumn(GridControl gridControl, FieldColumn fieldColumn, int n, String string) {
        try {
            this.m_nFieldType = n;
            String string2 = fieldColumn.getFieldName();
            String string3 = Desktop.getUniqueName(gridControl.xNameAccess, string2);
            String string4 = this.getGridColumnName();
            XPropertySet xPropertySet = gridControl.xGridColumnFactory.createColumn(string4);
            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)string3);
            boolean bl = false;
            if (n == -4) {
                bl = true;
            }
            xPropertySet.setPropertyValue("Hidden", (Object)bl);
            xPropertySet.setPropertyValue("DataField", (Object)string2);
            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_LABEL, (Object)string);
            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_WIDTH, (Object)0);
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            if (xPropertySetInfo.hasPropertyByName("MouseWheelBehavior")) {
                xPropertySet.setPropertyValue("MouseWheelBehavior", (Object)0);
            }
            this.setNumericLimits();
            gridControl.xNameContainer.insertByName(string2, (Object)xPropertySet);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public DatabaseControl(FormHandler formHandler, String string, Point point) {
        super(formHandler, string, point);
    }

    public DatabaseControl(FormHandler formHandler, XNameContainer xNameContainer, String string, int n, Point point) {
        super(formHandler, xNameContainer, formHandler.getControlType(n), string, point, null);
        try {
            this.m_nFieldType = n;
            Helper.setUnoPropertyValue(this.xControlModel, "DataField", string);
            this.setNumericLimits();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private String getGridColumnName() {
        for (int i = 0; i < FormHandler.oControlData.length; ++i) {
            if (FormHandler.oControlData[i].DataType != this.getFieldType()) continue;
            return FormHandler.oControlData[i].GridColumnName;
        }
        return PropertyNames.EMPTY_STRING;
    }

    public int getControlHeight() {
        if (this.getControlType() == 7) {
            return this.oFormHandler.getControlReferenceHeight() * 4;
        }
        if (this.getFieldType() == -1) {
            return this.oFormHandler.getControlReferenceHeight() * 4;
        }
        if (this.getControlType() == 2) {
            return super.getPreferredHeight();
        }
        return this.oFormHandler.getControlReferenceHeight();
    }

    public int getControlWidth() {
        if (this.getControlType() == 7) {
            return 2 * this.getControlHeight();
        }
        if (this.getFieldType() == -1) {
            return 2 * this.getControlHeight();
        }
        return this.getPreferredWidth();
    }

    private void setNumericLimits() {
        try {
            if (this.getControlType() == 5) {
                this.xPropertySet.setPropertyValue("TreatAsNumber", (Object)Boolean.TRUE);
                switch (this.getFieldType()) {
                    case -5: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(9.223372036854776E18));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-9.223372036854776E18));
                        break;
                    }
                    case 4: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(2.147483647E9));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-2.147483648E9));
                        break;
                    }
                    case 5: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(32767.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-32768.0));
                        break;
                    }
                    case -6: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(127.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-128.0));
                        break;
                    }
                }
            } else if (this.getControlType() == 7) {
                this.xPropertySet.setPropertyValue("ScaleMode", (Object)1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

