/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.layouter.style.resolver.ResolveHandlerModule;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public final class ResolveHandlerSorter {
    private ResolveHandlerSorter() {
    }

    public static ResolveHandlerModule[] sort(ResolveHandlerModule[] resolveHandlerModuleArray) {
        int n;
        HashMap<StyleKey, SortModule> hashMap = new HashMap<StyleKey, SortModule>();
        for (int i = 0; i < resolveHandlerModuleArray.length; ++i) {
            hashMap.put(resolveHandlerModuleArray[i].getKey(), new SortModule(resolveHandlerModuleArray[i]));
        }
        Object[] objectArray = hashMap.values().toArray(new SortModule[hashMap.size()]);
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < objectArray.length; ++n) {
            SortModule sortModule = objectArray[n];
            ResolveHandlerSorter.computeSubsystemModules(sortModule, arrayList, hashMap);
            arrayList.clear();
        }
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                int n2 = ResolveHandlerSorter.searchModulePosition((SortModule)object, hashMap);
                if (n2 == ((SortModule)object).getPosition()) continue;
                ((SortModule)object).setPosition(n2);
                n = 1;
            }
        }
        Arrays.sort(objectArray);
        ResolveHandlerModule[] resolveHandlerModuleArray2 = new ResolveHandlerModule[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            resolveHandlerModuleArray2[i] = ((SortModule)objectArray[i]).getModule();
        }
        return resolveHandlerModuleArray2;
    }

    private static int searchModulePosition(SortModule sortModule, HashMap hashMap) {
        int n = 0;
        StyleKey[] styleKeyArray = sortModule.getDependentKeys();
        for (int i = 0; i < styleKeyArray.length; ++i) {
            SortModule sortModule2 = (SortModule)hashMap.get(styleKeyArray[i]);
            if (sortModule2 == null || sortModule2.getPosition() < n) continue;
            n = sortModule2.getPosition() + 1;
        }
        return n;
    }

    private static void computeSubsystemModules(SortModule sortModule, ArrayList arrayList, HashMap hashMap) {
        if (arrayList.contains(sortModule)) {
            throw new IllegalStateException("Loop detected:" + sortModule + " (" + arrayList + ')');
        }
        StyleKey[] styleKeyArray = sortModule.getDependentKeys();
        arrayList.add(sortModule);
        for (int i = 0; i < styleKeyArray.length; ++i) {
            StyleKey styleKey = styleKeyArray[i];
            if (styleKey.equals(sortModule.getKey())) {
                throw new IllegalStateException("module referencing itself as dependency");
            }
            SortModule sortModule2 = (SortModule)hashMap.get(styleKey);
            if (sortModule2 == null) {
                DebugLog.log((Object)("Documented dependency but have no module for that one: " + styleKey));
                continue;
            }
            ResolveHandlerSorter.computeSubsystemModules(sortModule2, arrayList, hashMap);
            sortModule.addKeys(sortModule2.getDependentKeys());
        }
        arrayList.remove(sortModule);
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final StyleKey key;
        private StyleKey[] dependentKeys;
        private HashSet dependentKeySet;
        private ResolveHandlerModule module;

        private SortModule(ResolveHandlerModule resolveHandlerModule) {
            this.key = resolveHandlerModule.getKey();
            this.module = resolveHandlerModule;
            this.dependentKeySet = new HashSet();
            this.addKeys(resolveHandlerModule.getDependentKeys());
        }

        public boolean isDependency(StyleKey styleKey) {
            return this.dependentKeySet.contains(styleKey);
        }

        public ResolveHandlerModule getModule() {
            return this.module;
        }

        public StyleKey[] getDependentKeys() {
            if (this.dependentKeys == null) {
                this.dependentKeys = this.dependentKeySet.toArray(new StyleKey[this.dependentKeySet.size()]);
            }
            return this.dependentKeys;
        }

        public void addKeys(StyleKey[] styleKeyArray) {
            boolean bl = false;
            for (int i = 0; i < styleKeyArray.length; ++i) {
                StyleKey styleKey = styleKeyArray[i];
                if (!this.dependentKeySet.add(styleKey)) continue;
                bl = true;
            }
            if (bl) {
                this.dependentKeys = null;
            }
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
            this.module.setWeight(n);
        }

        public StyleKey getKey() {
            return this.key;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SortModule: ");
            stringBuffer.append(this.position);
            stringBuffer.append(' ');
            stringBuffer.append(this.getKey().getName());
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            SortModule sortModule = (SortModule)object;
            if (this.position > sortModule.position) {
                return 1;
            }
            if (this.position < sortModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

