/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import org.jfree.layouting.modules.output.html.HtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessorMetaData;
import org.jfree.layouting.modules.output.html.HtmlPrinter;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.AbstractPageableProcessor;
import org.jfree.layouting.output.pageable.AllPageFlowSelector;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.dummy.DummyRepository;

public class PageableHtmlOutputProcessor
extends AbstractPageableProcessor
implements HtmlOutputProcessor {
    private HtmlOutputProcessorMetaData metaData;
    private PageFlowSelector flowSelector = new AllPageFlowSelector(true);
    private HtmlPrinter printer;

    public PageableHtmlOutputProcessor(Configuration configuration) {
        super(configuration);
        AWTFontRegistry aWTFontRegistry = new AWTFontRegistry();
        DefaultFontStorage defaultFontStorage = new DefaultFontStorage((FontRegistry)aWTFontRegistry);
        this.metaData = new HtmlOutputProcessorMetaData((FontStorage)defaultFontStorage, 2);
        ContentLocation contentLocation = new DummyRepository().getRoot();
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(contentLocation);
        ContentLocation contentLocation2 = new DummyRepository().getRoot();
        DefaultNameGenerator defaultNameGenerator2 = new DefaultNameGenerator(contentLocation2);
        this.printer = new HtmlPrinter();
        this.printer.setContentWriter(contentLocation, (NameGenerator)defaultNameGenerator);
        this.printer.setDataWriter(contentLocation2, (NameGenerator)defaultNameGenerator2);
    }

    @Override
    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public void setPrinter(HtmlPrinter htmlPrinter) {
        this.printer = htmlPrinter;
    }

    @Override
    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPageBox, int n, int n2, PhysicalPageKey physicalPageKey) {
    }

    @Override
    protected void processLogicalPage(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox) {
        try {
            this.printer.generate(logicalPageBox, this.getDocumentContext());
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to generate content.", exception);
        }
    }

    @Override
    public PageFlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(PageFlowSelector pageFlowSelector) {
        this.flowSelector = pageFlowSelector;
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }
}

