/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.wagon.shared;

import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.apache.maven.wagon.providers.http.httpclient.conn.ssl.TrustStrategy;

public class RelaxedTrustStrategy
implements TrustStrategy {
    private final boolean ignoreSSLValidityDates;

    public RelaxedTrustStrategy(boolean ignoreSSLValidityDates) {
        this.ignoreSSLValidityDates = ignoreSSLValidityDates;
    }

    @Override
    public boolean isTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && certificates.length > 0) {
            for (X509Certificate currentCertificate : certificates) {
                try {
                    currentCertificate.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    if (this.ignoreSSLValidityDates) continue;
                    throw e;
                }
                catch (CertificateNotYetValidException e) {
                    if (this.ignoreSSLValidityDates) continue;
                    throw e;
                }
            }
            return true;
        }
        return false;
    }
}

