/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;

public class BoundsOutlineHandle
extends AbstractHandle {
    private AttributeKey<Stroke> stroke1Enabled;
    private AttributeKey<Stroke> stroke2Enabled;
    private AttributeKey<Stroke> stroke1Disabled;
    private AttributeKey<Stroke> stroke2Disabled;
    private AttributeKey<Color> strokeColor1Enabled;
    private AttributeKey<Color> strokeColor2Enabled;
    private AttributeKey<Color> strokeColor1Disabled;
    private AttributeKey<Color> strokeColor2Disabled;

    public BoundsOutlineHandle(Figure figure) {
        this(figure, false, false);
    }

    public BoundsOutlineHandle(Figure figure, boolean bl, boolean bl2) {
        super(figure);
        if (bl) {
            if (bl2) {
                this.stroke1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_1_HOVER;
                this.strokeColor1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_1_HOVER;
                this.stroke2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_2_HOVER;
                this.strokeColor2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_2_HOVER;
            } else {
                this.stroke1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_1;
                this.strokeColor1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_1;
                this.stroke2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_2;
                this.strokeColor2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_2;
            }
            this.stroke1Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_1_DISABLED;
            this.strokeColor1Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_1_DISABLED;
            this.stroke2Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_2_DISABLED;
            this.strokeColor2Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_2_DISABLED;
        } else {
            if (bl2) {
                this.stroke1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_1_HOVER;
                this.strokeColor1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_1_HOVER;
                this.stroke2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_2_HOVER;
                this.strokeColor2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_2_HOVER;
            } else {
                this.stroke1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_1;
                this.strokeColor1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_1;
                this.stroke2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_2;
                this.strokeColor2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_2;
            }
            this.stroke1Disabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_1_DISABLED;
            this.strokeColor1Disabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_1_DISABLED;
            this.stroke2Disabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_2_DISABLED;
            this.strokeColor2Disabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_2_DISABLED;
        }
    }

    public BoundsOutlineHandle(Figure figure, AttributeKey<Stroke> attributeKey, AttributeKey<Color> attributeKey2, AttributeKey<Stroke> attributeKey3, AttributeKey<Color> attributeKey4, AttributeKey<Stroke> attributeKey5, AttributeKey<Color> attributeKey6, AttributeKey<Stroke> attributeKey7, AttributeKey<Color> attributeKey8) {
        super(figure);
        this.stroke1Enabled = attributeKey;
        this.strokeColor1Enabled = attributeKey2;
        this.stroke2Enabled = attributeKey3;
        this.strokeColor2Enabled = attributeKey4;
        this.stroke1Disabled = attributeKey5;
        this.strokeColor1Disabled = attributeKey6;
        this.stroke2Disabled = attributeKey7;
        this.strokeColor2Disabled = attributeKey8;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Shape shape = this.getOwner().getBounds();
        if (this.getOwner().get(AttributeKeys.TRANSFORM) != null) {
            shape = this.getOwner().get(AttributeKeys.TRANSFORM).createTransformedShape(shape);
        }
        shape = this.view.getDrawingToViewTransform().createTransformedShape(shape);
        Rectangle rectangle = shape.getBounds();
        rectangle.grow(2, 2);
        return rectangle;
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void trackStart(Point point, int n) {
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Color color;
        Stroke stroke;
        Color color2;
        Stroke stroke2;
        Shape shape = this.getOwner().getBounds();
        if (this.getOwner().get(AttributeKeys.TRANSFORM) != null) {
            shape = this.getOwner().get(AttributeKeys.TRANSFORM).createTransformedShape(shape);
        }
        shape = this.view.getDrawingToViewTransform().createTransformedShape(shape);
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            stroke2 = this.getEditor().getHandleAttribute(this.stroke1Enabled);
            color2 = this.getEditor().getHandleAttribute(this.strokeColor1Enabled);
            stroke = this.getEditor().getHandleAttribute(this.stroke2Enabled);
            color = this.getEditor().getHandleAttribute(this.strokeColor2Enabled);
        } else {
            stroke2 = this.getEditor().getHandleAttribute(this.stroke1Disabled);
            color2 = this.getEditor().getHandleAttribute(this.strokeColor1Disabled);
            stroke = this.getEditor().getHandleAttribute(this.stroke2Disabled);
            color = this.getEditor().getHandleAttribute(this.strokeColor2Disabled);
        }
        if (stroke2 != null && color2 != null) {
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color2);
            graphics2D.draw(shape);
        }
        if (stroke != null && color != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
    }
}

