/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseDwrpHandler;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.dwrp.CallBatch;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.ParameterProperty;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.SimpleInputStreamFactory;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.impl.ExportUtil;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.util.DebuggingPrintWriter;
import org.directwebremoting.util.LocalUtil;

public abstract class BaseCallHandler
extends BaseDwrpHandler {
    protected boolean debug = false;
    protected Remoter remoter = null;
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    protected String accessLogLevel = null;
    protected PageNormalizer pageNormalizer = null;
    protected ScriptSessionManager scriptSessionManager = null;
    protected ConverterManager converterManager = null;
    protected ModuleManager moduleManager = null;
    protected static final String ATTRIBUTE_BATCH = "org.directwebremoting.dwrp.batch";
    private static final Log log = LogFactory.getLog(BaseCallHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean scriptPrefixSent = false;
        ScriptConduit conduit = null;
        try {
            PrintWriter out;
            CallBatch batch = new CallBatch(request);
            request.setAttribute(ATTRIBUTE_BATCH, (Object)batch);
            this.checkGetAllowed(batch);
            boolean checkCsrf = false;
            for (int i = 0; i < batch.getCalls().getCallCount(); ++i) {
                Call call = batch.getCalls().getCall(i);
                if (ExportUtil.isUnprotectedSystemMethod(call.getScriptName(), call.getMethodName())) continue;
                checkCsrf = true;
                break;
            }
            if (checkCsrf) {
                this.checkNotCsrfAttack(request, batch);
            }
            this.storeParsedRequest(request, batch);
            String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
            RealScriptSession scriptSession = this.scriptSessionManager.getOrCreateScriptSession(batch.getScriptSessionId(), normalizedPage, request.getSession(false));
            RealWebContext webContext = (RealWebContext)WebContextFactory.get();
            webContext.initialize(normalizedPage, scriptSession);
            Calls calls = this.marshallInbound(batch);
            Replies replies = this.remoter.execute(calls);
            if (this.debugScriptOutput || AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0) {
                DebuggingPrintWriter dpw = new DebuggingPrintWriter("", response.getWriter());
                dpw.setPrefix("out(" + replies.hashCode() + "): ");
                out = dpw;
            } else {
                out = response.getWriter();
            }
            conduit = this.createScriptConduit(out, batch.getInstanceId(), batch.getBatchId(), batch.getDocumentDomain());
            scriptPrefixSent = true;
            this.marshallOutbound(batch, replies, response, conduit, out);
            if (checkCsrf) {
                this.updateCsrfState(request, batch);
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                if (LocalUtil.getRootCause(ex) instanceof IOException) {
                    log.debug((Object)"I/O error while processing batch", (Throwable)ex);
                } else {
                    log.warn((Object)"Exception while processing batch", (Throwable)ex);
                }
            }
            this.marshallException(request, response, conduit, ex, !scriptPrefixSent);
        }
    }

    public Calls marshallInbound(CallBatch batch) {
        Calls calls = batch.getCalls();
        for (int callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            try {
                InboundContext inctx = batch.getInboundContexts().get(callNum);
                call.findMethod(this.moduleManager, this.converterManager, inctx, callNum);
                MethodDeclaration method = call.getMethodDeclaration();
                if (method == null) {
                    log.warn((Object)("No methods to match " + call.getScriptName() + '.' + call.getMethodName()));
                    throw new IllegalArgumentException("Missing method or missing parameter converters");
                }
                inctx.dereference();
                int destParamCount = method.getParameterTypes().length;
                Object[] arguments = new Object[destParamCount];
                int inboundArgIndex = 0;
                for (int outboundArgIndex = 0; outboundArgIndex < destParamCount; ++outboundArgIndex) {
                    InboundVariable param = method.isVarArgs() && outboundArgIndex + 1 == destParamCount ? inctx.createArrayWrapper(callNum, destParamCount) : inctx.getParameter(callNum, inboundArgIndex);
                    ParameterProperty property = new ParameterProperty(method, outboundArgIndex);
                    Class<?> paramType = method.getParameterTypes()[outboundArgIndex];
                    try {
                        arguments[outboundArgIndex] = this.converterManager.convertInbound(paramType, param, property);
                    }
                    catch (Exception ex) {
                        log.debug((Object)("Problem converting param=" + param + ", property=" + property + ", into paramType=" + paramType.getName() + ": " + ex));
                        throw ex;
                    }
                    if (LocalUtil.isServletClass(paramType)) continue;
                    ++inboundArgIndex;
                }
                call.setParameters(arguments);
                continue;
            }
            catch (Exception ex) {
                log.debug((Object)"Marshalling exception", (Throwable)ex);
                call.setMarshallFailure(ex);
            }
        }
        return calls;
    }

    private void storeParsedRequest(HttpServletRequest request, CallBatch batch) throws IOException {
        Map<String, FormField> paramMap = batch.getExtraParameters();
        if (!paramMap.isEmpty()) {
            for (Map.Entry<String, FormField> entry : paramMap.entrySet()) {
                Object value;
                String key = entry.getKey();
                FormField formField = entry.getValue();
                if (formField == null) {
                    log.warn((Object)"Found a parameter with a null value. This is likely to be due to a URL with an & before the query parameters. Please URL encode such pages.");
                    throw new IllegalArgumentException("Empty input parameter. See logs for suggestions");
                }
                if (formField.isFile()) {
                    SimpleInputStreamFactory inFactory = new SimpleInputStreamFactory(formField.getInputStream());
                    value = new FileTransfer(formField.getName(), formField.getMimeType(), formField.getFileSize(), inFactory);
                } else {
                    value = formField.getString();
                }
                if (key.startsWith("a-")) {
                    request.setAttribute(key.substring("a-".length()), value);
                    log.debug((Object)("Moved param to request: " + key + "=" + value));
                    continue;
                }
                log.debug((Object)("Ignoring parameter: " + key + "=" + value));
            }
        }
    }

    public void marshallOutbound(Batch batch, Replies replies, HttpServletResponse response, ScriptConduit conduit, PrintWriter out) throws Exception {
        RealScriptSession scriptSession;
        try {
            scriptSession = (RealScriptSession)WebContextFactory.get().getScriptSession();
        }
        catch (SecurityException ex) {
            return;
        }
        boolean passiveReverseAjax = false;
        long nextScriptIndex = -1L;
        if (batch.getNextReverseAjaxIndex() != null) {
            passiveReverseAjax = true;
            nextScriptIndex = batch.getNextReverseAjaxIndex();
        }
        response.setContentType(conduit.getOutboundMimeType());
        if (passiveReverseAjax) {
            scriptSession.confirmScripts(nextScriptIndex - 1L);
        }
        boolean beginningRunnable = false;
        RealScriptSession.Script script = null;
        if (passiveReverseAjax && (script = scriptSession.getScript(nextScriptIndex)) != null && script.getScript() instanceof Runnable) {
            ((Runnable)script.getScript()).run();
            beginningRunnable = true;
        }
        conduit.beginStreamAndChunk();
        if (beginningRunnable) {
            conduit.sendScript(EnginePrivate.getRemoteHandleReverseAjaxScript(script.getIndex(), ""));
            nextScriptIndex = script.getIndex() + 1L;
        }
        if (passiveReverseAjax) {
            out.println("//#DWR-INSERT");
            while ((script = scriptSession.getScript(nextScriptIndex)) != null && script.getScript() instanceof String) {
                conduit.sendScript(EnginePrivate.getRemoteHandleReverseAjaxScript(script.getIndex(), (String)script.getScript()));
                nextScriptIndex = script.getIndex() + 1L;
            }
        }
        out.println("//#DWR-REPLY");
        String batchId = replies.getCalls().getBatchId();
        for (int i = 0; i < replies.getReplyCount(); ++i) {
            ScriptBuffer scriptBuf;
            Reply reply = replies.getReply(i);
            String callId = reply.getCallId();
            try {
                ScriptBuffer scriptBuf2;
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    scriptBuf2 = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                } else {
                    Object data = reply.getReply();
                    scriptBuf2 = EnginePrivate.getRemoteHandleCallbackScript(batchId, callId, data);
                }
                conduit.sendScript(ScriptBufferUtil.createOutput(scriptBuf2, this.converterManager, this.jsonOutput));
                continue;
            }
            catch (IOException ex) {
                log.error((Object)("--Output Error: batchId[" + batchId + "] message[" + ex.toString() + ']'), (Throwable)ex);
                continue;
            }
            catch (ConversionException ex) {
                scriptBuf = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                this.addScriptHandleExceptions(conduit, scriptBuf);
                log.warn((Object)("--ConversionException: batchId=" + batchId + " class=" + ex.getConversionType().getName()), (Throwable)ex);
                continue;
            }
            catch (Exception ex) {
                scriptBuf = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                this.addScriptHandleExceptions(conduit, scriptBuf);
                log.error((Object)("--ConversionException: batchId=" + batchId + " message=" + ex.toString()));
            }
        }
        conduit.endStreamAndChunk();
    }

    public void marshallException(HttpServletRequest request, HttpServletResponse response, ScriptConduit conduit, Exception ex, boolean sendPrefix) throws IOException {
        String batchId = null;
        String instanceId = "0";
        String documentDomain = null;
        Batch batch = (Batch)request.getAttribute(ATTRIBUTE_BATCH);
        if (batch != null) {
            batchId = batch.getBatchId();
            instanceId = batch.getInstanceId();
            documentDomain = batch.getDocumentDomain();
        }
        PrintWriter out = response.getWriter();
        if (conduit == null) {
            conduit = this.createScriptConduit(out, instanceId, batchId, documentDomain);
        }
        response.setContentType(conduit.getOutboundMimeType());
        if (sendPrefix) {
            conduit.beginStreamAndChunk();
        }
        String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, ex);
        out.println(script);
        conduit.endStreamAndChunk();
    }

    public void addScriptHandleExceptions(ScriptConduit conduit, ScriptBuffer script) throws IOException {
        try {
            conduit.sendScript(ScriptBufferUtil.createOutput(script, this.converterManager, this.jsonOutput));
        }
        catch (ConversionException ex) {
            log.warn((Object)"Error marshalling exception. Is the exception converter configured?", (Throwable)ex);
        }
    }

    protected abstract ScriptConduit createScriptConduit(PrintWriter var1, String var2, String var3, String var4);

    public boolean isConvertable(Class<?> paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    public void setAccessLogLevel(String accessLogLevel) {
        this.accessLogLevel = accessLogLevel;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

