"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupFindingsRoutes = setupFindingsRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupFindingsRoutes(services, router) {
  const {
    findingsService
  } = services;
  router.get({
    path: `${_constants.API.GET_FINDINGS}`,
    validate: {
      query: _configSchema.schema.object({
        detectorType: _configSchema.schema.maybe(_configSchema.schema.string()),
        detectorId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, findingsService.getFindings);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkZpbmRpbmdzUm91dGVzLnRzIl0sIm5hbWVzIjpbInNldHVwRmluZGluZ3NSb3V0ZXMiLCJzZXJ2aWNlcyIsInJvdXRlciIsImZpbmRpbmdzU2VydmljZSIsImdldCIsInBhdGgiLCJBUEkiLCJHRVRfRklORElOR1MiLCJ2YWxpZGF0ZSIsInF1ZXJ5Iiwic2NoZW1hIiwib2JqZWN0IiwiZGV0ZWN0b3JUeXBlIiwibWF5YmUiLCJzdHJpbmciLCJkZXRlY3RvcklkIiwiZ2V0RmluZGluZ3MiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFNQTs7QUFFQTs7QUFSQTtBQUNBO0FBQ0E7QUFDQTtBQU9PLFNBQVNBLG1CQUFULENBQTZCQyxRQUE3QixFQUFxREMsTUFBckQsRUFBc0U7QUFDM0UsUUFBTTtBQUFFQyxJQUFBQTtBQUFGLE1BQXNCRixRQUE1QjtBQUVBQyxFQUFBQSxNQUFNLENBQUNFLEdBQVAsQ0FDRTtBQUNFQyxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsZUFBSUMsWUFBYSxFQUQ1QjtBQUVFQyxJQUFBQSxRQUFRLEVBQUU7QUFDUkMsTUFBQUEsS0FBSyxFQUFFQyxxQkFBT0MsTUFBUCxDQUFjO0FBQ25CQyxRQUFBQSxZQUFZLEVBQUVGLHFCQUFPRyxLQUFQLENBQWFILHFCQUFPSSxNQUFQLEVBQWIsQ0FESztBQUVuQkMsUUFBQUEsVUFBVSxFQUFFTCxxQkFBT0csS0FBUCxDQUFhSCxxQkFBT0ksTUFBUCxFQUFiO0FBRk8sT0FBZDtBQURDO0FBRlosR0FERixFQVVFWCxlQUFlLENBQUNhLFdBVmxCO0FBWUQiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IElSb3V0ZXIgfSBmcm9tICdvcGVuc2VhcmNoLWRhc2hib2FyZHMvc2VydmVyJztcbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XG5pbXBvcnQgeyBOb2RlU2VydmljZXMgfSBmcm9tICcuLi9tb2RlbHMvaW50ZXJmYWNlcyc7XG5pbXBvcnQgeyBBUEkgfSBmcm9tICcuLi91dGlscy9jb25zdGFudHMnO1xuXG5leHBvcnQgZnVuY3Rpb24gc2V0dXBGaW5kaW5nc1JvdXRlcyhzZXJ2aWNlczogTm9kZVNlcnZpY2VzLCByb3V0ZXI6IElSb3V0ZXIpIHtcbiAgY29uc3QgeyBmaW5kaW5nc1NlcnZpY2UgfSA9IHNlcnZpY2VzO1xuXG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogYCR7QVBJLkdFVF9GSU5ESU5HU31gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGRldGVjdG9yVHlwZTogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXG4gICAgICAgICAgZGV0ZWN0b3JJZDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGZpbmRpbmdzU2VydmljZS5nZXRGaW5kaW5nc1xuICApO1xufVxuIl19